/*
 *========================================================================
 * $Id: random_pvm_slave_work.c,v 1.4 2004/03/09 06:09:57 rgb Exp $
 *
 * See copyright in copyright.h and the accompanying file COPYING
 *========================================================================
 */

/*
 *========================================================================
 *  Project work template.
 *========================================================================
 */

#include "random_pvm_slave.h"

void random_pvm_work()
{

 char c;
 int i,j,mytid,numrands;
 unsigned long int seed;
 double *rand;

 mytid = pvm_mytid();
 ptid = pvm_parent();
 

 msgtag = 0;
 pvm_recv(ptid,0);
 pvm_upkint(&numrands,1,1);
 pvm_upkulong(&seed,1,1);
 pvm_upkint(&batchcom,1,1);

 rand = (double *)malloc((size_t)numrands*sizeof(double));
 
 /* Here we do some work.  The amount is controlled by nwork. */
 srandom(seed);
 for(i=0;i<numrands;i++){
   /*
    * Simulated work is "generate and return a uniform deviate"...
    * NOTE WELL: my_nanosleep is a pure polling loop that counts
    * cycles until a specified number of nanoseconds is reached.
    * It "should" be accurate to about 100 nanoseconds.  Nothing
    * is around that is any better, and most things cost 2 usec
    * or more for a sleep of any kind.
    */
   if(delay) my_nanosleep(delay);

   /*
    * OR use this one for not terribly accurate delays.  usleep
    * seems to return after perhaps 0.001 seconds independent of its
    * argument, for example.  If you use this one, comment out
    * the other.
   if(delay) usleep(delay);
    */
   
   rand[i] = (double) random()/RAND_MAX;
   if(batchcom == 0){
     msgtag = 1;
     pvm_initsend(PvmDataDefault);
     pvm_pkdouble(&rand[i],1,1);
     pvm_send(ptid,msgtag);
   }
   /* ...badly (should use gsl mt19937, not random():-) */
   
 }

 if(batchcom){
   msgtag = 1;
   pvm_initsend(PvmDataDefault);
   pvm_pkdouble(rand,numrands,1);
   pvm_send(ptid,msgtag);
 }

 pvm_exit();
 
}
