/*
 *========================================================================
 * $Id: random_pvm_master_work.c,v 1.4 2004/03/09 06:09:57 rgb Exp $
 *
 * See copyright in copyright.h and the accompanying file COPYING
 *========================================================================
 */

/*
 *========================================================================
 *  Project work template.
 *========================================================================
 */

#include "random_pvm_master.h"

void random_pvm_work()
{

 int i,info,nr,rcnt,task_ids[K],nrands_per_host[K];
 unsigned long int seed;
 char c,hostname[64];
 char *args[4];
 double tstart,tstop,ttime;
 double *rand,*rptr;

 /*
  * Make argument list for slave tasks.
 args[0] = (char *)malloc(32);
 snprintf(args[0],17,"random_pvm_slave");
  */
 args[0] = (char *)malloc(32);
 snprintf(args[0],3,"-d");
 args[1] = (char *)malloc(32);
 snprintf(args[1],16,"%d",delay);
 args[2] = (char *)0;

 /*
  * Test my_nanosleep.  Appears to work to within 10 nanoseconds!
  * Not bad!
 tstart = nanotimer();
 my_nanosleep(11);
 tstop = nanotimer();
 ttime = (tstop - tstart);
 printf("ttime = %f\n",ttime);
  */

 /*
  * Split up nrands precisely and lazily (outside timer).
  * This balances our "load".  This is a pure port of taskmaster.
  */
 nr = 0;
 i = 0;
 while(nr < numrands){
   nrands_per_host[i]++;
   nr++;
   i++;
   i %= numslaves;
 }

 /*
  * We need a buffer to hold all the rands returned by all the hosts.
  * in this particular version, we're going to just create a huge
  * vector of rands in memory.
  */
 rand = (double *)malloc((size_t) numrands*sizeof(double));
 rptr = rand;

 /*
  * Start timer(s) and spawn remote tasks
  */
 tstart = gtod_nanotimer();
 tstart = nanotimer();

 /*
  * Spawn numslaves slave tasks on the current cluster.  Note that we
  * don't check for more slave tasks than nodes, and we don't YET start
  * or repair the PVM cluster itself inside the master application,
  * although in principle we could.  We should really check the error
  * code returned in cc for trouble...
  */
 cc = pvm_spawn("random_pvm_slave",args,PvmTaskDefault,"",numslaves,task_ids);
 if(verbose){
   printf("Spawned %d tasks.\n",cc);
 }

 /*
  * We send each slave a simple signal/message to begin.  In this
  * case the message is the integer number of rands we want each
  * slave task to make.
  */
 msgtag = 0;
 for(i=0;i<numslaves;i++){
   seed = i + 1;
   if(verbose){
     printf("Sending slave %d seed %lu and asking it to make %d rands.\n",
        i,seed,nrands_per_host[i]);
   }
   pvm_initsend(PvmDataDefault);
   pvm_pkint(&nrands_per_host[i],1,1);
   pvm_pkulong(&seed,1,1);
   pvm_pkint(&batchcom,1,1);
   info = pvm_send(task_ids[i],msgtag);
   if(info < 0){
     pvm_perror("Failed to send");
   }
   if(verbose){
     printf("Done!\n");
   }
 }
   
 /*
  * Then we try to collect results from each slave.  This is NOT ROBUST
  * to slave/node failure.  In future columns we might try to make it
  * robust...
  */
 rcnt = 0;
 while(rcnt < numrands){
   for(i=0;i<numslaves;i++){
     msgtag = 1;
     pvm_recv(task_ids[i],msgtag);
     if(batchcom){
       pvm_upkdouble(rptr,nrands_per_host[i],1);
       if(verbose){
         printf("Receiving/unpacking %d rands starting with %10.8f.\n",
	   nrands_per_host[i],*rptr);
       }
       rptr += nrands_per_host[i];
       rcnt += nrands_per_host[i];
     } else {
       pvm_upkdouble(rptr,1,1);
       if(verbose){
         printf("Receiving/unpacking %10.8f.\n",*rptr);
       }
       rptr++;
       rcnt++;
       if(rcnt == numrands) break;
     }
   }
 }

 tstop = nanotimer();
 /* In seconds */
 ttime = 1.e-9*(tstop - tstart);

 /*
  * Now we print out the results and the timing.
  */
 if(verbose){
   for(i = 0;i<numrands;i++){
     printf("rand[%d] = %10.8f\n",i,rand[i]);
   }
   printf("\n");
 }
 if(verbose){
   printf("Results:\n");
   printf("%8s %8s %8s %8s\n","nhosts","nrands","delay","time");
 }
 printf(" %5d  %8d %8d %16.10f\n",numslaves,numrands,delay,ttime);

 pvm_exit();

}
