/*
 *========================================================================
 * $Id: parsecl_slave.c,v 1.1.1.1 2003/12/17 18:44:20 rgb Exp $
 *
 * See copyright in copyright.h and the accompanying file COPYING
 *========================================================================
 */

#include "random_pvm_slave.h"

/*
 * This routine sets certain globals to their default values and permits
 * those defaults to be overridden on the command line.
 */

void parsecl(int argc, char **argv)
{
 int opt_c,opt_errflg=0;
 extern char *optarg;
 extern int optind, opterr, optopt;

 /* 
  * Initialize global variables with defaults, then override if
  * desired on command line.  Read the getopt man page to see how
  * to set other variables.  Or insert your own parsing code in here --
  * Sometimes I use getopts, sometimes I parse myself, sometimes both.
  */
 verbose = 0;   /* Default is quiet */
 delay = 1;     /* default is to sleep one second */

 while ((opt_c = getopt(argc,argv,"d:hv")) != EOF){
   switch (opt_c){
     case 'd':
       delay = strtol(optarg,(char **) NULL,10);
       break;
     case 'h':
       Usage();
       exit(0);
       break;
     case 'v':
       verbose = 1;
       break;
     case '?':
       opt_errflg++;
   }
 }

 /*
  * If there are no more arguments, we are done.
  */
 if(argc-optind == 0){
   return;
 }

 /*
  * Anything else left is an erroneous call and should cause the Usage
  * message to be printed.  memtest -h or --help will therefore "work".
  */

 Usage();

}

void Usage()
{

 fprintf(stdout, "\n");
 fprintf(stdout, "Usage: \n");
 fprintf(stdout, "  random_pvm [-h] [-v]\n");
 fprintf(stdout, "\n");
 fprintf(stdout, "   -v selects \"verbose\" operation for debugging, very noisy.\n");
 fprintf(stdout, "   -h prints usage statement (this message) and exits.\n");
 fprintf(stdout, "\n");
 exit(0);

}
