# The following should match PROGRAM, VERSION and RELEASE in the
# Makefile accompanying this program (and the .tgz defined in Source
# below.
%define name project_pvm
%define version 1.0.0
%define release 1

%define builddir $RPM_BUILD_DIR/%{name}-%{version}.%{release}

Summary: A simple C source master/slave pvm project template

Name: %{name}
Version: %{version}
Release: %{release}
Group: Development
License: Open Source (GPL v2b)
Source: %{name}.tgz
Buildroot: /var/tmp/%{name}-%{version}-%{release}-root

%description 
This is a very simple PVM master/slave project template.  It contains
all that is needed to start a simple C master/slave parallel project.
Note that it is NOT GNU autoconf based and hence not terribly compatible
with e.g. glade, but on the other hand one can build tarballs and rpm's
with ease. The package's primary author (as of 12/17/03) can be
contacted at rgb@phy.duke.edu.

%prep
%setup -q -n %{name}

%build
make clean
make

%install
make PREFIX=%{buildroot}/usr/share/pvm3 install

%clean
rm -rf $RPM_BUILD_ROOT
rm -rf %{builddir}

%files 
%defattr(644,root,root)
# The project binaries
%attr(755,root,root) /usr/share/pvm3/bin/LINUX/project_master
%attr(755,root,root) /usr/share/pvm3/bin/LINUX/project_slave
# The project man page
%attr(644,root,root) /usr/share/pvm3/share/man/man1/project_pvm.1.gz

%post

%postun

%changelog
* Wed Dec  17 2003 Robert G. Brown <rgb@duke.edu>
- set up and built for RH 9
