/*
 *========================================================================
 * $Id: project_master_work.c,v 1.6 2003/12/17 18:43:11 rgb Exp $
 *
 * See copyright in copyright.h and the accompanying file COPYING
 *========================================================================
 */

/*
 *========================================================================
 *  Project work template.
 *========================================================================
 */

#include "project_master.h"

void project_work()
{

 int i,task_ids[K];
 char c;

 char *args[3];
 args[0] = (char *)malloc(16);
 snprintf(args[0],3,"-d");
 args[1] = (char *)malloc(16);
 snprintf(args[1],16,"%d",delay);
 args[2] = (char *)0;

 printf("Hello World master/slave application run on cluster of %d nodes.\n",numslaves);
 printf("This is the master, pvm tid = t%x.\n",pvm_mytid());
 snprintf(buf,K,"Hello, World! from ");
 i = strlen(buf);
 gethostname(buf + i,(size_t) 64);
 printf("%s\n",buf);
 if(verbose){
   fprintf(STDERR,"About to spawn \"Hello, World!\" tasks on cluster\n");
 }

 /*
  * Spawn numslaves slave tasks on the current cluster
  */
 cc = pvm_spawn("project_slave",args,PvmTaskDefault,"",numslaves,task_ids);

 /*
  * We look through and send each slave a simple signal to begin
  */
 for(i=0;i<numslaves;i++){
   pvm_initsend(PvmDataDefault);
   pvm_pkint(&i,1,1);
   pvm_send(task_ids[i],0);
 }

   
 /*
  * Then we try to collect results from each slave.
  */
 for(i=0;i<numslaves;i++){
   msgtag = 1;
   pvm_recv(task_ids[i],msgtag);
   pvm_upkstr(buf);
   printf("This is the slave, pvm tid =  t%x.\n",task_ids[i]);
   printf("%s\n",buf);
 }

 pvm_exit();

}
