/**************************************************************************
 * This program is Copyright (C) 1986-2002 by Jonathan Payne.  JOVE is    *
 * provided by Jonathan and Jovehacks without charge and without          *
 * warranty.  You may copy, modify, and/or distribute JOVE, provided that *
 * this notice is included in all the source files and documentation.     *
 **************************************************************************/

/* keys.c is derived from keys.txt by setmaps */

/* Only edit keys.txt, not keys.c.
 *
 * keys.txt is processed as text by setmaps.  This means that what follows
 * is a very restricted subset of C.
 *
 * - Lines beginning with "#if", "#else", and "#endif" are understood
 *   to be the parts of conditional compilation.
 *   They will not be recognized if they are "spelled" differently
 *   (say, with whitespace).  Generally, there ought to be the same
 *   number of table entries in each branch of the if.
 *
 * - On a Mac, lines begining with "#MENU" are used to specify that
 *   the table is for a menu.
 *
 * - Lines begining with a tab followed by a " are treated as table entries.
 *
 * - Other lines are passed through, and are assumed to delimit tables.
 *   This means that they must not be within tables.
 */

#include "jove.h"
#include "commands.h"

data_obj *MainKeys[NCHARS] = {
	(data_obj *) &commands[190],	/* ^@ */
	(data_obj *) &commands[16],	/* ^A */
	(data_obj *) &commands[7],	/* ^B */
	(data_obj *) NULL,		/* ^C */
	(data_obj *) &commands[45],	/* ^D */
	(data_obj *) &commands[71],	/* ^E */
	(data_obj *) &commands[88],	/* ^F */
	(data_obj *) NULL,		/* ^G */
	(data_obj *) &commands[47],	/* ^H */
	(data_obj *) &commands[100],	/* ^I */
	(data_obj *) &commands[128],	/* ^J */
	(data_obj *) &commands[114],	/* ^K */
	(data_obj *) &commands[163],	/* ^L */
	(data_obj *) &commands[126],	/* ^M */
	(data_obj *) &commands[130],	/* ^N */
	(data_obj *) &commands[127],	/* ^O */
	(data_obj *) &commands[143],	/* ^P */
	(data_obj *) &commands[159],	/* ^Q */
	(data_obj *) &commands[175],	/* ^R */
	(data_obj *) &commands[173],	/* ^S */
	(data_obj *) &commands[209],	/* ^T */
	(data_obj *) &commands[95],	/* ^U */
	(data_obj *) &commands[131],	/* ^V */
	(data_obj *) &commands[110],	/* ^W */
	(data_obj *) NULL,		/* ^X */
	(data_obj *) &commands[236],	/* ^Y */
	(data_obj *) &commands[172],	/* ^Z */
	(data_obj *) NULL,		/* ESC */
#ifdef MAC	/* peculiar cursor key codes */
	(data_obj *) &commands[7],	/* ^\ */
	(data_obj *) &commands[88],	/* ^] */
	(data_obj *) &commands[143],	/* ^^ */
	(data_obj *) &commands[130],	/* ^_ */
#else
	(data_obj *) &commands[173],	/* ^\ */
	(data_obj *) &commands[86],	/* ^] */
	(data_obj *) &commands[159],	/* ^^ */
	(data_obj *) NULL,		/* ^_ */
#endif
	(data_obj *) &commands[188],	/*   */
	(data_obj *) &commands[188],	/* ! */
	(data_obj *) &commands[188],	/* " */
	(data_obj *) &commands[188],	/* # */
	(data_obj *) &commands[188],	/* $ */
	(data_obj *) &commands[188],	/* % */
	(data_obj *) &commands[188],	/* & */
	(data_obj *) &commands[188],	/* ' */
	(data_obj *) &commands[188],	/* ( */
	(data_obj *) &commands[136],	/* ) */
	(data_obj *) &commands[188],	/* * */
	(data_obj *) &commands[188],	/* + */
	(data_obj *) &commands[188],	/* , */
	(data_obj *) &commands[188],	/* - */
	(data_obj *) &commands[188],	/* . */
	(data_obj *) &commands[188],	/* / */
	(data_obj *) &commands[188],	/* 0 */
	(data_obj *) &commands[188],	/* 1 */
	(data_obj *) &commands[188],	/* 2 */
	(data_obj *) &commands[188],	/* 3 */
	(data_obj *) &commands[188],	/* 4 */
	(data_obj *) &commands[188],	/* 5 */
	(data_obj *) &commands[188],	/* 6 */
	(data_obj *) &commands[188],	/* 7 */
	(data_obj *) &commands[188],	/* 8 */
	(data_obj *) &commands[188],	/* 9 */
	(data_obj *) &commands[188],	/* : */
	(data_obj *) &commands[188],	/* ; */
	(data_obj *) &commands[188],	/* < */
	(data_obj *) &commands[188],	/* = */
	(data_obj *) &commands[188],	/* > */
	(data_obj *) &commands[188],	/* ? */
	(data_obj *) &commands[188],	/* @ */
	(data_obj *) &commands[188],	/* A */
	(data_obj *) &commands[188],	/* B */
	(data_obj *) &commands[188],	/* C */
	(data_obj *) &commands[188],	/* D */
	(data_obj *) &commands[188],	/* E */
	(data_obj *) &commands[188],	/* F */
	(data_obj *) &commands[188],	/* G */
	(data_obj *) &commands[188],	/* H */
	(data_obj *) &commands[188],	/* I */
	(data_obj *) &commands[188],	/* J */
	(data_obj *) &commands[188],	/* K */
	(data_obj *) &commands[188],	/* L */
	(data_obj *) &commands[188],	/* M */
	(data_obj *) &commands[188],	/* N */
	(data_obj *) &commands[188],	/* O */
	(data_obj *) &commands[188],	/* P */
	(data_obj *) &commands[188],	/* Q */
	(data_obj *) &commands[188],	/* R */
	(data_obj *) &commands[188],	/* S */
	(data_obj *) &commands[188],	/* T */
	(data_obj *) &commands[188],	/* U */
	(data_obj *) &commands[188],	/* V */
	(data_obj *) &commands[188],	/* W */
	(data_obj *) &commands[188],	/* X */
	(data_obj *) &commands[188],	/* Y */
	(data_obj *) &commands[188],	/* Z */
	(data_obj *) &commands[188],	/* [ */
	(data_obj *) &commands[188],	/* \ */
	(data_obj *) &commands[136],	/* ] */
	(data_obj *) &commands[188],	/* ^ */
	(data_obj *) &commands[188],	/* _ */
	(data_obj *) &commands[188],	/* ` */
	(data_obj *) &commands[188],	/* a */
	(data_obj *) &commands[188],	/* b */
	(data_obj *) &commands[188],	/* c */
	(data_obj *) &commands[188],	/* d */
	(data_obj *) &commands[188],	/* e */
	(data_obj *) &commands[188],	/* f */
	(data_obj *) &commands[188],	/* g */
	(data_obj *) &commands[188],	/* h */
	(data_obj *) &commands[188],	/* i */
	(data_obj *) &commands[188],	/* j */
	(data_obj *) &commands[188],	/* k */
	(data_obj *) &commands[188],	/* l */
	(data_obj *) &commands[188],	/* m */
	(data_obj *) &commands[188],	/* n */
	(data_obj *) &commands[188],	/* o */
	(data_obj *) &commands[188],	/* p */
	(data_obj *) &commands[188],	/* q */
	(data_obj *) &commands[188],	/* r */
	(data_obj *) &commands[188],	/* s */
	(data_obj *) &commands[188],	/* t */
	(data_obj *) &commands[188],	/* u */
	(data_obj *) &commands[188],	/* v */
	(data_obj *) &commands[188],	/* w */
	(data_obj *) &commands[188],	/* x */
	(data_obj *) &commands[188],	/* y */
	(data_obj *) &commands[188],	/* z */
	(data_obj *) &commands[188],	/* { */
	(data_obj *) &commands[188],	/* | */
	(data_obj *) &commands[136],	/* } */
	(data_obj *) &commands[188],	/* ~ */
	(data_obj *) &commands[47],	/* ^? */
#if NCHARS != 128
	(data_obj *) &commands[188],	/* M-^@ */
	(data_obj *) &commands[188],	/* M-^A */
	(data_obj *) &commands[188],	/* M-^B */
	(data_obj *) &commands[188],	/* M-^C */
	(data_obj *) &commands[188],	/* M-^D */
	(data_obj *) &commands[188],	/* M-^E */
	(data_obj *) &commands[188],	/* M-^F */
	(data_obj *) &commands[188],	/* M-^G */
	(data_obj *) &commands[188],	/* M-^H */
	(data_obj *) &commands[188],	/* M-^I */
	(data_obj *) &commands[188],	/* M-^J */
	(data_obj *) &commands[188],	/* M-^K */
	(data_obj *) &commands[188],	/* M-^L */
	(data_obj *) &commands[188],	/* M-^M */
	(data_obj *) &commands[188],	/* M-^N */
	(data_obj *) &commands[188],	/* M-^O */
	(data_obj *) &commands[188],	/* M-^P */
	(data_obj *) &commands[188],	/* M-^Q */
	(data_obj *) &commands[188],	/* M-^R */
	(data_obj *) &commands[188],	/* M-^S */
	(data_obj *) &commands[188],	/* M-^T */
	(data_obj *) &commands[188],	/* M-^U */
	(data_obj *) &commands[188],	/* M-^V */
	(data_obj *) &commands[188],	/* M-^W */
	(data_obj *) &commands[188],	/* M-^X */
	(data_obj *) &commands[188],	/* M-^Y */
	(data_obj *) &commands[188],	/* M-^Z */
	(data_obj *) &commands[188],	/* M-ESC */
	(data_obj *) &commands[188],	/* M-^\ */
	(data_obj *) &commands[188],	/* M-^] */
	(data_obj *) &commands[188],	/* M-^^ */
	(data_obj *) &commands[188],	/* M-^_ */
	(data_obj *) &commands[188],	/* M-  */
	(data_obj *) &commands[188],	/* M-! */
	(data_obj *) &commands[188],	/* M-" */
	(data_obj *) &commands[188],	/* M-# */
	(data_obj *) &commands[188],	/* M-$ */
	(data_obj *) &commands[188],	/* M-% */
	(data_obj *) &commands[188],	/* M-& */
	(data_obj *) &commands[188],	/* M-' */
	(data_obj *) &commands[188],	/* M-( */
	(data_obj *) &commands[188],	/* M-) */
	(data_obj *) &commands[188],	/* M-* */
	(data_obj *) &commands[188],	/* M-+ */
	(data_obj *) &commands[188],	/* M-, */
	(data_obj *) &commands[188],	/* M-- */
	(data_obj *) &commands[188],	/* M-. */
	(data_obj *) &commands[188],	/* M-/ */
	(data_obj *) &commands[188],	/* M-0 */
	(data_obj *) &commands[188],	/* M-1 */
	(data_obj *) &commands[188],	/* M-2 */
	(data_obj *) &commands[188],	/* M-3 */
	(data_obj *) &commands[188],	/* M-4 */
	(data_obj *) &commands[188],	/* M-5 */
	(data_obj *) &commands[188],	/* M-6 */
	(data_obj *) &commands[188],	/* M-7 */
	(data_obj *) &commands[188],	/* M-8 */
	(data_obj *) &commands[188],	/* M-9 */
	(data_obj *) &commands[188],	/* M-: */
	(data_obj *) &commands[188],	/* M-; */
	(data_obj *) &commands[188],	/* M-< */
	(data_obj *) &commands[188],	/* M-= */
	(data_obj *) &commands[188],	/* M-> */
	(data_obj *) &commands[188],	/* M-? */
	(data_obj *) &commands[188],	/* M-@ */
	(data_obj *) &commands[188],	/* M-A */
	(data_obj *) &commands[188],	/* M-B */
	(data_obj *) &commands[188],	/* M-C */
	(data_obj *) &commands[188],	/* M-D */
	(data_obj *) &commands[188],	/* M-E */
	(data_obj *) &commands[188],	/* M-F */
	(data_obj *) &commands[188],	/* M-G */
	(data_obj *) &commands[188],	/* M-H */
	(data_obj *) &commands[188],	/* M-I */
	(data_obj *) &commands[188],	/* M-J */
	(data_obj *) &commands[188],	/* M-K */
	(data_obj *) &commands[188],	/* M-L */
	(data_obj *) &commands[188],	/* M-M */
	(data_obj *) &commands[188],	/* M-N */
	(data_obj *) &commands[188],	/* M-O */
	(data_obj *) &commands[188],	/* M-P */
	(data_obj *) &commands[188],	/* M-Q */
	(data_obj *) &commands[188],	/* M-R */
	(data_obj *) &commands[188],	/* M-S */
	(data_obj *) &commands[188],	/* M-T */
	(data_obj *) &commands[188],	/* M-U */
	(data_obj *) &commands[188],	/* M-V */
	(data_obj *) &commands[188],	/* M-W */
	(data_obj *) &commands[188],	/* M-X */
	(data_obj *) &commands[188],	/* M-Y */
	(data_obj *) &commands[188],	/* M-Z */
	(data_obj *) &commands[188],	/* M-[ */
	(data_obj *) &commands[188],	/* M-\ */
	(data_obj *) &commands[188],	/* M-] */
	(data_obj *) &commands[188],	/* M-^ */
	(data_obj *) &commands[188],	/* M-_ */
	(data_obj *) &commands[188],	/* M-` */
	(data_obj *) &commands[188],	/* M-a */
	(data_obj *) &commands[188],	/* M-b */
	(data_obj *) &commands[188],	/* M-c */
	(data_obj *) &commands[188],	/* M-d */
	(data_obj *) &commands[188],	/* M-e */
	(data_obj *) &commands[188],	/* M-f */
	(data_obj *) &commands[188],	/* M-g */
	(data_obj *) &commands[188],	/* M-h */
	(data_obj *) &commands[188],	/* M-i */
	(data_obj *) &commands[188],	/* M-j */
	(data_obj *) &commands[188],	/* M-k */
	(data_obj *) &commands[188],	/* M-l */
	(data_obj *) &commands[188],	/* M-m */
	(data_obj *) &commands[188],	/* M-n */
	(data_obj *) &commands[188],	/* M-o */
	(data_obj *) &commands[188],	/* M-p */
	(data_obj *) &commands[188],	/* M-q */
	(data_obj *) &commands[188],	/* M-r */
	(data_obj *) &commands[188],	/* M-s */
	(data_obj *) &commands[188],	/* M-t */
	(data_obj *) &commands[188],	/* M-u */
	(data_obj *) &commands[188],	/* M-v */
	(data_obj *) &commands[188],	/* M-w */
	(data_obj *) &commands[188],	/* M-x */
	(data_obj *) &commands[188],	/* M-y */
	(data_obj *) &commands[188],	/* M-z */
	(data_obj *) &commands[188],	/* M-{ */
	(data_obj *) &commands[188],	/* M-| */
	(data_obj *) &commands[188],	/* M-} */
	(data_obj *) &commands[188],	/* M-~ */
#ifdef PCNONASCII
	(data_obj *) NULL,		/* M-^? */
#else
	(data_obj *) &commands[188],	/* M-^? */
#endif
#endif /* NCHARS != 128 */
};

data_obj *EscKeys[NCHARS] = {
	(data_obj *) &commands[190],	/* ^@ */
	(data_obj *) NULL,		/* ^A */
	(data_obj *) &commands[10],	/* ^B */
	(data_obj *) NULL,		/* ^C */
	(data_obj *) &commands[66],	/* ^D */
	(data_obj *) NULL,		/* ^E */
	(data_obj *) &commands[91],	/* ^F */
	(data_obj *) NULL,		/* ^G */
	(data_obj *) NULL,		/* ^H */
	(data_obj *) NULL,		/* ^I */
	(data_obj *) NULL,		/* ^J */
	(data_obj *) &commands[111],	/* ^K */
	(data_obj *) &commands[32],	/* ^L */
	(data_obj *) NULL,		/* ^M */
	(data_obj *) &commands[89],	/* ^N */
	(data_obj *) NULL,		/* ^O */
	(data_obj *) &commands[8],	/* ^P */
	(data_obj *) NULL,		/* ^Q */
	(data_obj *) NULL,		/* ^R */
	(data_obj *) NULL,		/* ^S */
	(data_obj *) NULL,		/* ^T */
	(data_obj *) &commands[12],	/* ^U */
	(data_obj *) &commands[135],	/* ^V */
	(data_obj *) NULL,		/* ^W */
	(data_obj *) NULL,		/* ^X */
	(data_obj *) NULL,		/* ^Y */
	(data_obj *) NULL,		/* ^Z */
	(data_obj *) NULL,		/* ESC */
	(data_obj *) NULL,		/* ^\ */
	(data_obj *) NULL,		/* ^] */
	(data_obj *) NULL,		/* ^^ */
	(data_obj *) NULL,		/* ^_ */
	(data_obj *) NULL,		/*   */
	(data_obj *) NULL,		/* ! */
	(data_obj *) NULL,		/* " */
	(data_obj *) NULL,		/* # */
	(data_obj *) NULL,		/* $ */
	(data_obj *) NULL,		/* % */
	(data_obj *) NULL,		/* & */
	(data_obj *) NULL,		/* ' */
	(data_obj *) NULL,		/* ( */
	(data_obj *) NULL,		/* ) */
	(data_obj *) NULL,		/* * */
	(data_obj *) NULL,		/* + */
	(data_obj *) &commands[17],	/* , */
	(data_obj *) &commands[64],	/* - */
	(data_obj *) &commands[72],	/* . */
	(data_obj *) NULL,		/* / */
	(data_obj *) &commands[53],	/* 0 */
	(data_obj *) &commands[53],	/* 1 */
	(data_obj *) &commands[53],	/* 2 */
	(data_obj *) &commands[53],	/* 3 */
	(data_obj *) &commands[53],	/* 4 */
	(data_obj *) &commands[53],	/* 5 */
	(data_obj *) &commands[53],	/* 6 */
	(data_obj *) &commands[53],	/* 7 */
	(data_obj *) &commands[53],	/* 8 */
	(data_obj *) &commands[53],	/* 9 */
	(data_obj *) NULL,		/* : */
	(data_obj *) NULL,		/* ; */
	(data_obj *) &commands[15],	/* < */
	(data_obj *) NULL,		/* = */
	(data_obj *) &commands[70],	/* > */
	(data_obj *) &commands[50],	/* ? */
	(data_obj *) NULL,		/* @ */
	(data_obj *) &commands[11],	/* A */
	(data_obj *) &commands[13],	/* B */
	(data_obj *) &commands[27],	/* C */
	(data_obj *) &commands[107],	/* D */
	(data_obj *) &commands[92],	/* E */
	(data_obj *) &commands[93],	/* F */
	(data_obj *) &commands[96],	/* G */
	(data_obj *) NULL,		/* H */
	(data_obj *) &commands[124],	/* I */
	(data_obj *) &commands[81],	/* J */
	(data_obj *) &commands[115],	/* K */
	(data_obj *) &commands[28],	/* L */
	(data_obj *) &commands[87],	/* M */
	(data_obj *) NULL,		/* N */
	(data_obj *) NULL,		/* O */
	(data_obj *) NULL,		/* P */
	(data_obj *) &commands[157],	/* Q */
	(data_obj *) &commands[166],	/* R */
	(data_obj *) NULL,		/* S */
	(data_obj *) NULL,		/* T */
	(data_obj *) &commands[29],	/* U */
	(data_obj *) &commands[144],	/* V */
	(data_obj *) &commands[35],	/* W */
	(data_obj *) &commands[78],	/* X */
	(data_obj *) &commands[237],	/* Y */
	(data_obj *) &commands[169],	/* Z */
	(data_obj *) &commands[9],	/* [ */
	(data_obj *) &commands[48],	/* \ */
	(data_obj *) &commands[90],	/* ] */
	(data_obj *) NULL,		/* ^ */
	(data_obj *) NULL,		/* _ */
	(data_obj *) NULL,		/* ` */
	(data_obj *) &commands[11],	/* a */
	(data_obj *) &commands[13],	/* b */
	(data_obj *) &commands[27],	/* c */
	(data_obj *) &commands[107],	/* d */
	(data_obj *) &commands[92],	/* e */
	(data_obj *) &commands[93],	/* f */
	(data_obj *) &commands[96],	/* g */
	(data_obj *) NULL,		/* h */
	(data_obj *) &commands[124],	/* i */
	(data_obj *) &commands[81],	/* j */
	(data_obj *) &commands[115],	/* k */
	(data_obj *) &commands[28],	/* l */
	(data_obj *) &commands[87],	/* m */
	(data_obj *) NULL,		/* n */
	(data_obj *) NULL,		/* o */
	(data_obj *) NULL,		/* p */
	(data_obj *) &commands[157],	/* q */
	(data_obj *) &commands[166],	/* r */
	(data_obj *) NULL,		/* s */
	(data_obj *) NULL,		/* t */
	(data_obj *) &commands[29],	/* u */
	(data_obj *) &commands[144],	/* v */
	(data_obj *) &commands[35],	/* w */
	(data_obj *) &commands[78],	/* x */
	(data_obj *) &commands[237],	/* y */
	(data_obj *) &commands[169],	/* z */
	(data_obj *) NULL,		/* { */
	(data_obj *) NULL,		/* | */
	(data_obj *) NULL,		/* } */
	(data_obj *) &commands[123],	/* ~ */
	(data_obj *) &commands[108],	/* ^? */
#if NCHARS != 128
	(data_obj *) NULL,		/* M-^@ */
	(data_obj *) NULL,		/* M-^A */
	(data_obj *) NULL,		/* M-^B */
	(data_obj *) NULL,		/* M-^C */
	(data_obj *) NULL,		/* M-^D */
	(data_obj *) NULL,		/* M-^E */
	(data_obj *) NULL,		/* M-^F */
	(data_obj *) NULL,		/* M-^G */
	(data_obj *) NULL,		/* M-^H */
	(data_obj *) NULL,		/* M-^I */
	(data_obj *) NULL,		/* M-^J */
	(data_obj *) NULL,		/* M-^K */
	(data_obj *) NULL,		/* M-^L */
	(data_obj *) NULL,		/* M-^M */
	(data_obj *) NULL,		/* M-^N */
	(data_obj *) NULL,		/* M-^O */
	(data_obj *) NULL,		/* M-^P */
	(data_obj *) NULL,		/* M-^Q */
	(data_obj *) NULL,		/* M-^R */
	(data_obj *) NULL,		/* M-^S */
	(data_obj *) NULL,		/* M-^T */
	(data_obj *) NULL,		/* M-^U */
	(data_obj *) NULL,		/* M-^V */
	(data_obj *) NULL,		/* M-^W */
	(data_obj *) NULL,		/* M-^X */
	(data_obj *) NULL,		/* M-^Y */
	(data_obj *) NULL,		/* M-^Z */
	(data_obj *) NULL,		/* M-ESC */
	(data_obj *) NULL,		/* M-^\ */
	(data_obj *) NULL,		/* M-^] */
	(data_obj *) NULL,		/* M-^^ */
	(data_obj *) NULL,		/* M-^_ */
	(data_obj *) NULL,		/* M-  */
	(data_obj *) NULL,		/* M-! */
	(data_obj *) NULL,		/* M-" */
	(data_obj *) NULL,		/* M-# */
	(data_obj *) NULL,		/* M-$ */
	(data_obj *) NULL,		/* M-% */
	(data_obj *) NULL,		/* M-& */
	(data_obj *) NULL,		/* M-' */
	(data_obj *) NULL,		/* M-( */
	(data_obj *) NULL,		/* M-) */
	(data_obj *) NULL,		/* M-* */
	(data_obj *) NULL,		/* M-+ */
	(data_obj *) NULL,		/* M-, */
	(data_obj *) NULL,		/* M-- */
	(data_obj *) NULL,		/* M-. */
	(data_obj *) NULL,		/* M-/ */
	(data_obj *) NULL,		/* M-0 */
	(data_obj *) NULL,		/* M-1 */
	(data_obj *) NULL,		/* M-2 */
	(data_obj *) NULL,		/* M-3 */
	(data_obj *) NULL,		/* M-4 */
	(data_obj *) NULL,		/* M-5 */
	(data_obj *) NULL,		/* M-6 */
	(data_obj *) NULL,		/* M-7 */
	(data_obj *) NULL,		/* M-8 */
	(data_obj *) NULL,		/* M-9 */
	(data_obj *) NULL,		/* M-: */
	(data_obj *) NULL,		/* M-; */
	(data_obj *) NULL,		/* M-< */
	(data_obj *) NULL,		/* M-= */
	(data_obj *) NULL,		/* M-> */
	(data_obj *) NULL,		/* M-? */
	(data_obj *) NULL,		/* M-@ */
	(data_obj *) NULL,		/* M-A */
	(data_obj *) NULL,		/* M-B */
	(data_obj *) NULL,		/* M-C */
	(data_obj *) NULL,		/* M-D */
	(data_obj *) NULL,		/* M-E */
	(data_obj *) NULL,		/* M-F */
	(data_obj *) NULL,		/* M-G */
	(data_obj *) NULL,		/* M-H */
	(data_obj *) NULL,		/* M-I */
	(data_obj *) NULL,		/* M-J */
	(data_obj *) NULL,		/* M-K */
	(data_obj *) NULL,		/* M-L */
	(data_obj *) NULL,		/* M-M */
	(data_obj *) NULL,		/* M-N */
	(data_obj *) NULL,		/* M-O */
	(data_obj *) NULL,		/* M-P */
	(data_obj *) NULL,		/* M-Q */
	(data_obj *) NULL,		/* M-R */
	(data_obj *) NULL,		/* M-S */
	(data_obj *) NULL,		/* M-T */
	(data_obj *) NULL,		/* M-U */
	(data_obj *) NULL,		/* M-V */
	(data_obj *) NULL,		/* M-W */
	(data_obj *) NULL,		/* M-X */
	(data_obj *) NULL,		/* M-Y */
	(data_obj *) NULL,		/* M-Z */
	(data_obj *) NULL,		/* M-[ */
	(data_obj *) NULL,		/* M-\ */
	(data_obj *) NULL,		/* M-] */
	(data_obj *) NULL,		/* M-^ */
	(data_obj *) NULL,		/* M-_ */
	(data_obj *) NULL,		/* M-` */
	(data_obj *) NULL,		/* M-a */
	(data_obj *) NULL,		/* M-b */
	(data_obj *) NULL,		/* M-c */
	(data_obj *) NULL,		/* M-d */
	(data_obj *) NULL,		/* M-e */
	(data_obj *) NULL,		/* M-f */
	(data_obj *) NULL,		/* M-g */
	(data_obj *) NULL,		/* M-h */
	(data_obj *) NULL,		/* M-i */
	(data_obj *) NULL,		/* M-j */
	(data_obj *) NULL,		/* M-k */
	(data_obj *) NULL,		/* M-l */
	(data_obj *) NULL,		/* M-m */
	(data_obj *) NULL,		/* M-n */
	(data_obj *) NULL,		/* M-o */
	(data_obj *) NULL,		/* M-p */
	(data_obj *) NULL,		/* M-q */
	(data_obj *) NULL,		/* M-r */
	(data_obj *) NULL,		/* M-s */
	(data_obj *) NULL,		/* M-t */
	(data_obj *) NULL,		/* M-u */
	(data_obj *) NULL,		/* M-v */
	(data_obj *) NULL,		/* M-w */
	(data_obj *) NULL,		/* M-x */
	(data_obj *) NULL,		/* M-y */
	(data_obj *) NULL,		/* M-z */
	(data_obj *) NULL,		/* M-{ */
	(data_obj *) NULL,		/* M-| */
	(data_obj *) NULL,		/* M-} */
	(data_obj *) NULL,		/* M-~ */
	(data_obj *) NULL,		/* M-^? */
#endif /* NCHARS != 128 */
};

data_obj	*CtlxKeys[NCHARS] = {
	(data_obj *) NULL,		/* ^@ */
	(data_obj *) NULL,		/* ^A */
	(data_obj *) &commands[118],	/* ^B */
	(data_obj *) &commands[79],	/* ^C */
	(data_obj *) NULL,		/* ^D */
#ifdef SUBSHELL
	(data_obj *) &commands[33],	/* ^E */
#else
	(data_obj *) NULL,		/* ^E */
#endif
	(data_obj *) &commands[84],	/* ^F */
	(data_obj *) NULL,		/* ^G */
	(data_obj *) NULL,		/* ^H */
	(data_obj *) &commands[104],	/* ^I */
	(data_obj *) NULL,		/* ^J */
	(data_obj *) NULL,		/* ^K */
	(data_obj *) NULL,		/* ^L */
	(data_obj *) &commands[219],	/* ^M */
	(data_obj *) &commands[129],	/* ^N */
	(data_obj *) &commands[42],	/* ^O */
	(data_obj *) &commands[142],	/* ^P */
	(data_obj *) NULL,		/* ^Q */
	(data_obj *) &commands[214],	/* ^R */
	(data_obj *) &commands[168],	/* ^S */
	(data_obj *) &commands[210],	/* ^T */
	(data_obj *) NULL,		/* ^U */
	(data_obj *) &commands[214],	/* ^V */
	(data_obj *) &commands[217],	/* ^W */
	(data_obj *) &commands[75],	/* ^X */
	(data_obj *) NULL,		/* ^Y */
	(data_obj *) NULL,		/* ^Z */
	(data_obj *) NULL,		/* ESC */
	(data_obj *) &commands[168],	/* ^\ */
	(data_obj *) NULL,		/* ^] */
	(data_obj *) NULL,		/* ^^ */
	(data_obj *) NULL,		/* ^_ */
	(data_obj *) NULL,		/*   */
#ifdef SUBSHELL
	(data_obj *) &commands[192],	/* ! */
#else
	(data_obj *) NULL,		/* ! */
#endif
	(data_obj *) NULL,		/* " */
	(data_obj *) NULL,		/* # */
	(data_obj *) NULL,		/* $ */
	(data_obj *) NULL,		/* % */
	(data_obj *) NULL,		/* & */
	(data_obj *) NULL,		/* ' */
	(data_obj *) &commands[14],	/* ( */
	(data_obj *) &commands[69],	/* ) */
	(data_obj *) NULL,		/* * */
	(data_obj *) NULL,		/* + */
	(data_obj *) NULL,		/* , */
	(data_obj *) NULL,		/* - */
	(data_obj *) NULL,		/* . */
	(data_obj *) NULL,		/* / */
	(data_obj *) NULL,		/* 0 */
	(data_obj *) &commands[46],	/* 1 */
	(data_obj *) &commands[202],	/* 2 */
	(data_obj *) NULL,		/* 3 */
	(data_obj *) &commands[215],	/* 4 */
	(data_obj *) NULL,		/* 5 */
	(data_obj *) NULL,		/* 6 */
	(data_obj *) NULL,		/* 7 */
	(data_obj *) NULL,		/* 8 */
	(data_obj *) NULL,		/* 9 */
	(data_obj *) NULL,		/* : */
	(data_obj *) NULL,		/* ; */
	(data_obj *) NULL,		/* < */
	(data_obj *) NULL,		/* = */
	(data_obj *) NULL,		/* > */
	(data_obj *) &commands[51],	/* ? */
	(data_obj *) NULL,		/* @ */
	(data_obj *) NULL,		/* A */
	(data_obj *) &commands[177],	/* B */
	(data_obj *) NULL,		/* C */
	(data_obj *) &commands[44],	/* D */
	(data_obj *) &commands[76],	/* E */
	(data_obj *) NULL,		/* F */
	(data_obj *) NULL,		/* G */
	(data_obj *) NULL,		/* H */
	(data_obj *) NULL,		/* I */
	(data_obj *) NULL,		/* J */
	(data_obj *) &commands[43],	/* K */
	(data_obj *) NULL,		/* L */
	(data_obj *) NULL,		/* M */
	(data_obj *) &commands[132],	/* N */
	(data_obj *) &commands[145],	/* O */
	(data_obj *) &commands[145],	/* P */
	(data_obj *) NULL,		/* Q */
	(data_obj *) NULL,		/* R */
	(data_obj *) &commands[168],	/* S */
	(data_obj *) &commands[85],	/* T */
	(data_obj *) NULL,		/* U */
	(data_obj *) NULL,		/* V */
	(data_obj *) NULL,		/* W */
	(data_obj *) NULL,		/* X */
	(data_obj *) NULL,		/* Y */
	(data_obj *) NULL,		/* Z */
	(data_obj *) NULL,		/* [ */
	(data_obj *) NULL,		/* \ */
	(data_obj *) NULL,		/* ] */
	(data_obj *) &commands[99],	/* ^ */
	(data_obj *) NULL,		/* _ */
	(data_obj *) NULL,		/* ` */
	(data_obj *) NULL,		/* a */
	(data_obj *) &commands[177],	/* b */
	(data_obj *) NULL,		/* c */
	(data_obj *) &commands[44],	/* d */
	(data_obj *) &commands[76],	/* e */
	(data_obj *) NULL,		/* f */
	(data_obj *) NULL,		/* g */
	(data_obj *) NULL,		/* h */
	(data_obj *) NULL,		/* i */
	(data_obj *) NULL,		/* j */
	(data_obj *) &commands[43],	/* k */
	(data_obj *) NULL,		/* l */
	(data_obj *) NULL,		/* m */
	(data_obj *) &commands[132],	/* n */
	(data_obj *) &commands[145],	/* o */
	(data_obj *) &commands[145],	/* p */
	(data_obj *) NULL,		/* q */
	(data_obj *) NULL,		/* r */
	(data_obj *) &commands[168],	/* s */
	(data_obj *) &commands[85],	/* t */
	(data_obj *) NULL,		/* u */
	(data_obj *) NULL,		/* v */
	(data_obj *) NULL,		/* w */
	(data_obj *) NULL,		/* x */
	(data_obj *) NULL,		/* y */
	(data_obj *) NULL,		/* z */
	(data_obj *) NULL,		/* { */
	(data_obj *) NULL,		/* | */
	(data_obj *) NULL,		/* } */
	(data_obj *) NULL,		/* ~ */
	(data_obj *) &commands[113],	/* ^? */
#if NCHARS != 128
	(data_obj *) NULL,		/* M-^@ */
	(data_obj *) NULL,		/* M-^A */
	(data_obj *) NULL,		/* M-^B */
	(data_obj *) NULL,		/* M-^C */
	(data_obj *) NULL,		/* M-^D */
	(data_obj *) NULL,		/* M-^E */
	(data_obj *) NULL,		/* M-^F */
	(data_obj *) NULL,		/* M-^G */
	(data_obj *) NULL,		/* M-^H */
	(data_obj *) NULL,		/* M-^I */
	(data_obj *) NULL,		/* M-^J */
	(data_obj *) NULL,		/* M-^K */
	(data_obj *) NULL,		/* M-^L */
	(data_obj *) NULL,		/* M-^M */
	(data_obj *) NULL,		/* M-^N */
	(data_obj *) NULL,		/* M-^O */
	(data_obj *) NULL,		/* M-^P */
	(data_obj *) NULL,		/* M-^Q */
	(data_obj *) NULL,		/* M-^R */
	(data_obj *) NULL,		/* M-^S */
	(data_obj *) NULL,		/* M-^T */
	(data_obj *) NULL,		/* M-^U */
	(data_obj *) NULL,		/* M-^V */
	(data_obj *) NULL,		/* M-^W */
	(data_obj *) NULL,		/* M-^X */
	(data_obj *) NULL,		/* M-^Y */
	(data_obj *) NULL,		/* M-^Z */
	(data_obj *) NULL,		/* M-ESC */
	(data_obj *) NULL,		/* M-^\ */
	(data_obj *) NULL,		/* M-^] */
	(data_obj *) NULL,		/* M-^^ */
	(data_obj *) NULL,		/* M-^_ */
	(data_obj *) NULL,		/* M-  */
	(data_obj *) NULL,		/* M-! */
	(data_obj *) NULL,		/* M-" */
	(data_obj *) NULL,		/* M-# */
	(data_obj *) NULL,		/* M-$ */
	(data_obj *) NULL,		/* M-% */
	(data_obj *) NULL,		/* M-& */
	(data_obj *) NULL,		/* M-' */
	(data_obj *) NULL,		/* M-( */
	(data_obj *) NULL,		/* M-) */
	(data_obj *) NULL,		/* M-* */
	(data_obj *) NULL,		/* M-+ */
	(data_obj *) NULL,		/* M-, */
	(data_obj *) NULL,		/* M-- */
	(data_obj *) NULL,		/* M-. */
	(data_obj *) NULL,		/* M-/ */
	(data_obj *) NULL,		/* M-0 */
	(data_obj *) NULL,		/* M-1 */
	(data_obj *) NULL,		/* M-2 */
	(data_obj *) NULL,		/* M-3 */
	(data_obj *) NULL,		/* M-4 */
	(data_obj *) NULL,		/* M-5 */
	(data_obj *) NULL,		/* M-6 */
	(data_obj *) NULL,		/* M-7 */
	(data_obj *) NULL,		/* M-8 */
	(data_obj *) NULL,		/* M-9 */
	(data_obj *) NULL,		/* M-: */
	(data_obj *) NULL,		/* M-; */
	(data_obj *) NULL,		/* M-< */
	(data_obj *) NULL,		/* M-= */
	(data_obj *) NULL,		/* M-> */
	(data_obj *) NULL,		/* M-? */
	(data_obj *) NULL,		/* M-@ */
	(data_obj *) NULL,		/* M-A */
	(data_obj *) NULL,		/* M-B */
	(data_obj *) NULL,		/* M-C */
	(data_obj *) NULL,		/* M-D */
	(data_obj *) NULL,		/* M-E */
	(data_obj *) NULL,		/* M-F */
	(data_obj *) NULL,		/* M-G */
	(data_obj *) NULL,		/* M-H */
	(data_obj *) NULL,		/* M-I */
	(data_obj *) NULL,		/* M-J */
	(data_obj *) NULL,		/* M-K */
	(data_obj *) NULL,		/* M-L */
	(data_obj *) NULL,		/* M-M */
	(data_obj *) NULL,		/* M-N */
	(data_obj *) NULL,		/* M-O */
	(data_obj *) NULL,		/* M-P */
	(data_obj *) NULL,		/* M-Q */
	(data_obj *) NULL,		/* M-R */
	(data_obj *) NULL,		/* M-S */
	(data_obj *) NULL,		/* M-T */
	(data_obj *) NULL,		/* M-U */
	(data_obj *) NULL,		/* M-V */
	(data_obj *) NULL,		/* M-W */
	(data_obj *) NULL,		/* M-X */
	(data_obj *) NULL,		/* M-Y */
	(data_obj *) NULL,		/* M-Z */
	(data_obj *) NULL,		/* M-[ */
	(data_obj *) NULL,		/* M-\ */
	(data_obj *) NULL,		/* M-] */
	(data_obj *) NULL,		/* M-^ */
	(data_obj *) NULL,		/* M-_ */
	(data_obj *) NULL,		/* M-` */
	(data_obj *) NULL,		/* M-a */
	(data_obj *) NULL,		/* M-b */
	(data_obj *) NULL,		/* M-c */
	(data_obj *) NULL,		/* M-d */
	(data_obj *) NULL,		/* M-e */
	(data_obj *) NULL,		/* M-f */
	(data_obj *) NULL,		/* M-g */
	(data_obj *) NULL,		/* M-h */
	(data_obj *) NULL,		/* M-i */
	(data_obj *) NULL,		/* M-j */
	(data_obj *) NULL,		/* M-k */
	(data_obj *) NULL,		/* M-l */
	(data_obj *) NULL,		/* M-m */
	(data_obj *) NULL,		/* M-n */
	(data_obj *) NULL,		/* M-o */
	(data_obj *) NULL,		/* M-p */
	(data_obj *) NULL,		/* M-q */
	(data_obj *) NULL,		/* M-r */
	(data_obj *) NULL,		/* M-s */
	(data_obj *) NULL,		/* M-t */
	(data_obj *) NULL,		/* M-u */
	(data_obj *) NULL,		/* M-v */
	(data_obj *) NULL,		/* M-w */
	(data_obj *) NULL,		/* M-x */
	(data_obj *) NULL,		/* M-y */
	(data_obj *) NULL,		/* M-z */
	(data_obj *) NULL,		/* M-{ */
	(data_obj *) NULL,		/* M-| */
	(data_obj *) NULL,		/* M-} */
	(data_obj *) NULL,		/* M-~ */
	(data_obj *) NULL,		/* M-^? */
#endif /* NCHARS != 128 */
};

#ifdef PCNONASCII
/* These are codes generated by non-ASCII keys on an IBM-PC keyboard.
 * Codes marked with [E] are only generated by enhanced keyboards.
 * The codes 171 to 183 are synthesized by JOVE when it detects
 * shift + a code in 71 to 83.
 */
data_obj	*NonASCIIKeys[NCHARS] = {
	(data_obj *) NULL,		/* ^@ */
	(data_obj *) NULL,		/* ^A */
	(data_obj *) NULL,		/* ^B */
	(data_obj *) NULL,		/* ^C */
	(data_obj *) NULL,		/* ^D */
	(data_obj *) NULL,		/* ^E */
	(data_obj *) NULL,		/* ^F */
	(data_obj *) NULL,		/* ^G */
	(data_obj *) NULL,		/* ^H */
	(data_obj *) NULL,		/* ^I */
	(data_obj *) NULL,		/* ^J */
	(data_obj *) NULL,		/* ^K */
	(data_obj *) NULL,		/* ^L */
	(data_obj *) NULL,		/* ^M */
	(data_obj *) NULL,		/* ^N */
	(data_obj *) NULL,		/* ^O */
	(data_obj *) &commands[157],	/* ^P */
	(data_obj *) &commands[35],	/* ^Q */
	(data_obj *) &commands[92],	/* ^R */
	(data_obj *) &commands[166],	/* ^S */
	(data_obj *) NULL,		/* ^T */
	(data_obj *) &commands[237],	/* ^U */
	(data_obj *) &commands[29],	/* ^V */
	(data_obj *) &commands[124],	/* ^W */
	(data_obj *) NULL,		/* ^X */
	(data_obj *) NULL,		/* ^Y */
	(data_obj *) NULL,		/* ^Z */
	(data_obj *) NULL,		/* ESC */
	(data_obj *) NULL,		/* ^\ */
	(data_obj *) NULL,		/* ^] */
	(data_obj *) &commands[11],	/* ^^ */
	(data_obj *) NULL,		/* ^_ */
	(data_obj *) &commands[107],	/*   */
	(data_obj *) &commands[93],	/* ! */
	(data_obj *) &commands[96],	/* " */
	(data_obj *) NULL,		/* # */
	(data_obj *) &commands[81],	/* $ */
	(data_obj *) &commands[115],	/* % */
	(data_obj *) &commands[28],	/* & */
	(data_obj *) NULL,		/* ' */
	(data_obj *) NULL,		/* ( */
	(data_obj *) NULL,		/* ) */
	(data_obj *) NULL,		/* * */
	(data_obj *) NULL,		/* + */
	(data_obj *) &commands[169],	/* , */
	(data_obj *) &commands[78],	/* - */
	(data_obj *) &commands[27],	/* . */
	(data_obj *) &commands[144],	/* / */
	(data_obj *) &commands[13],	/* 0 */
	(data_obj *) NULL,		/* 1 */
	(data_obj *) &commands[87],	/* 2 */
	(data_obj *) NULL,		/* 3 */
	(data_obj *) NULL,		/* 4 */
	(data_obj *) NULL,		/* 5 */
	(data_obj *) NULL,		/* 6 */
	(data_obj *) NULL,		/* 7 */
	(data_obj *) NULL,		/* 8 */
	(data_obj *) NULL,		/* 9 */
	(data_obj *) NULL,		/* : */
	(data_obj *) NULL,		/* ; */
	(data_obj *) NULL,		/* < */
	(data_obj *) NULL,		/* = */
	(data_obj *) NULL,		/* > */
	(data_obj *) NULL,		/* ? */
	(data_obj *) NULL,		/* @ */
	(data_obj *) NULL,		/* A */
	(data_obj *) NULL,		/* B */
	(data_obj *) NULL,		/* C */
	(data_obj *) NULL,		/* D */
	(data_obj *) NULL,		/* E */
	(data_obj *) NULL,		/* F */
	(data_obj *) &commands[16],	/* G */
	(data_obj *) &commands[143],	/* H */
	(data_obj *) &commands[144],	/* I */
	(data_obj *) NULL,		/* J */
	(data_obj *) &commands[7],	/* K */
	(data_obj *) NULL,		/* L */
	(data_obj *) &commands[88],	/* M */
	(data_obj *) NULL,		/* N */
	(data_obj *) &commands[71],	/* O */
	(data_obj *) &commands[130],	/* P */
	(data_obj *) &commands[131],	/* Q */
	(data_obj *) &commands[134],	/* R */
	(data_obj *) NULL,		/* S */
	(data_obj *) NULL,		/* T */
	(data_obj *) NULL,		/* U */
	(data_obj *) NULL,		/* V */
	(data_obj *) NULL,		/* W */
	(data_obj *) NULL,		/* X */
	(data_obj *) NULL,		/* Y */
	(data_obj *) NULL,		/* Z */
	(data_obj *) NULL,		/* [ */
	(data_obj *) NULL,		/* \ */
	(data_obj *) NULL,		/* ] */
	(data_obj *) NULL,		/* ^ */
	(data_obj *) NULL,		/* _ */
	(data_obj *) NULL,		/* ` */
	(data_obj *) NULL,		/* a */
	(data_obj *) NULL,		/* b */
	(data_obj *) NULL,		/* c */
	(data_obj *) NULL,		/* d */
	(data_obj *) NULL,		/* e */
	(data_obj *) NULL,		/* f */
	(data_obj *) NULL,		/* g */
	(data_obj *) NULL,		/* h */
	(data_obj *) NULL,		/* i */
	(data_obj *) NULL,		/* j */
	(data_obj *) NULL,		/* k */
	(data_obj *) NULL,		/* l */
	(data_obj *) NULL,		/* m */
	(data_obj *) NULL,		/* n */
	(data_obj *) NULL,		/* o */
	(data_obj *) NULL,		/* p */
	(data_obj *) NULL,		/* q */
	(data_obj *) NULL,		/* r */
	(data_obj *) &commands[13],	/* s */
	(data_obj *) &commands[93],	/* t */
	(data_obj *) &commands[70],	/* u */
	(data_obj *) &commands[132],	/* v */
	(data_obj *) &commands[15],	/* w */
	(data_obj *) &commands[178],	/* x */
	(data_obj *) &commands[180],	/* y */
	(data_obj *) &commands[181],	/* z */
	(data_obj *) &commands[182],	/* { */
	(data_obj *) &commands[183],	/* | */
	(data_obj *) &commands[184],	/* } */
	(data_obj *) &commands[185],	/* ~ */
	(data_obj *) &commands[186],	/* ^? */
	(data_obj *) &commands[187],	/* M-^@ */
	(data_obj *) &commands[179],	/* M-^A */
	(data_obj *) NULL,		/* M-^B */
	(data_obj *) NULL,		/* M-^C */
	(data_obj *) &commands[145],	/* M-^D */
	(data_obj *) NULL,		/* M-^E */
	(data_obj *) NULL,		/* M-^F */
	(data_obj *) NULL,		/* M-^G */
	(data_obj *) NULL,		/* M-^H */
	(data_obj *) NULL,		/* M-^I */
	(data_obj *) NULL,		/* M-^J */
	(data_obj *) NULL,		/* M-^K */
	(data_obj *) NULL,		/* M-^L */
	(data_obj *) NULL,		/* M-^M */
	(data_obj *) NULL,		/* M-^N */
	(data_obj *) NULL,		/* M-^O */
	(data_obj *) NULL,		/* M-^P */
	(data_obj *) NULL,		/* M-^Q */
	(data_obj *) NULL,		/* M-^R */
	(data_obj *) NULL,		/* M-^S */
	(data_obj *) NULL,		/* M-^T */
	(data_obj *) NULL,		/* M-^U */
	(data_obj *) NULL,		/* M-^V */
	(data_obj *) NULL,		/* M-^W */
	(data_obj *) NULL,		/* M-^X */
	(data_obj *) NULL,		/* M-^Y */
	(data_obj *) NULL,		/* M-^Z */
	(data_obj *) NULL,		/* M-ESC */
	(data_obj *) NULL,		/* M-^\ */
	(data_obj *) NULL,		/* M-^] */
	(data_obj *) NULL,		/* M-^^ */
	(data_obj *) NULL,		/* M-^_ */
	(data_obj *) NULL,		/* M-  */
	(data_obj *) NULL,		/* M-! */
	(data_obj *) NULL,		/* M-" */
	(data_obj *) NULL,		/* M-# */
	(data_obj *) NULL,		/* M-$ */
	(data_obj *) NULL,		/* M-% */
	(data_obj *) NULL,		/* M-& */
	(data_obj *) NULL,		/* M-' */
	(data_obj *) NULL,		/* M-( */
	(data_obj *) NULL,		/* M-) */
	(data_obj *) NULL,		/* M-* */
	(data_obj *) NULL,		/* M-+ */
	(data_obj *) NULL,		/* M-, */
	(data_obj *) NULL,		/* M-- */
	(data_obj *) NULL,		/* M-. */
	(data_obj *) NULL,		/* M-/ */
	(data_obj *) NULL,		/* M-0 */
	(data_obj *) NULL,		/* M-1 */
	(data_obj *) NULL,		/* M-2 */
	(data_obj *) NULL,		/* M-3 */
	(data_obj *) NULL,		/* M-4 */
	(data_obj *) NULL,		/* M-5 */
	(data_obj *) NULL,		/* M-6 */
	(data_obj *) NULL,		/* M-7 */
	(data_obj *) NULL,		/* M-8 */
	(data_obj *) NULL,		/* M-9 */
	(data_obj *) NULL,		/* M-: */
	(data_obj *) NULL,		/* M-; */
	(data_obj *) NULL,		/* M-< */
	(data_obj *) NULL,		/* M-= */
	(data_obj *) NULL,		/* M-> */
	(data_obj *) NULL,		/* M-? */
	(data_obj *) NULL,		/* M-@ */
	(data_obj *) NULL,		/* M-A */
	(data_obj *) NULL,		/* M-B */
	(data_obj *) NULL,		/* M-C */
	(data_obj *) NULL,		/* M-D */
	(data_obj *) NULL,		/* M-E */
	(data_obj *) NULL,		/* M-F */
	(data_obj *) NULL,		/* M-G */
	(data_obj *) NULL,		/* M-H */
	(data_obj *) NULL,		/* M-I */
	(data_obj *) NULL,		/* M-J */
	(data_obj *) NULL,		/* M-K */
	(data_obj *) NULL,		/* M-L */
	(data_obj *) NULL,		/* M-M */
	(data_obj *) NULL,		/* M-N */
	(data_obj *) NULL,		/* M-O */
	(data_obj *) NULL,		/* M-P */
	(data_obj *) NULL,		/* M-Q */
	(data_obj *) NULL,		/* M-R */
	(data_obj *) NULL,		/* M-S */
	(data_obj *) NULL,		/* M-T */
	(data_obj *) NULL,		/* M-U */
	(data_obj *) NULL,		/* M-V */
	(data_obj *) NULL,		/* M-W */
	(data_obj *) NULL,		/* M-X */
	(data_obj *) NULL,		/* M-Y */
	(data_obj *) NULL,		/* M-Z */
	(data_obj *) NULL,		/* M-[ */
	(data_obj *) NULL,		/* M-\ */
	(data_obj *) NULL,		/* M-] */
	(data_obj *) NULL,		/* M-^ */
	(data_obj *) NULL,		/* M-_ */
	(data_obj *) NULL,		/* M-` */
	(data_obj *) NULL,		/* M-a */
	(data_obj *) NULL,		/* M-b */
	(data_obj *) NULL,		/* M-c */
	(data_obj *) NULL,		/* M-d */
	(data_obj *) NULL,		/* M-e */
	(data_obj *) NULL,		/* M-f */
	(data_obj *) NULL,		/* M-g */
	(data_obj *) NULL,		/* M-h */
	(data_obj *) NULL,		/* M-i */
	(data_obj *) NULL,		/* M-j */
	(data_obj *) NULL,		/* M-k */
	(data_obj *) NULL,		/* M-l */
	(data_obj *) NULL,		/* M-m */
	(data_obj *) NULL,		/* M-n */
	(data_obj *) NULL,		/* M-o */
	(data_obj *) NULL,		/* M-p */
	(data_obj *) NULL,		/* M-q */
	(data_obj *) NULL,		/* M-r */
	(data_obj *) NULL,		/* M-s */
	(data_obj *) NULL,		/* M-t */
	(data_obj *) NULL,		/* M-u */
	(data_obj *) NULL,		/* M-v */
	(data_obj *) NULL,		/* M-w */
	(data_obj *) NULL,		/* M-x */
	(data_obj *) NULL,		/* M-y */
	(data_obj *) NULL,		/* M-z */
	(data_obj *) NULL,		/* M-{ */
	(data_obj *) NULL,		/* M-| */
	(data_obj *) NULL,		/* M-} */
	(data_obj *) NULL,		/* M-~ */
	(data_obj *) NULL,		/* M-^? */
};
#endif /* PCNONASCII */
