/*
 *========================================================================
 * $Id: run_test.c 472 2008-09-22 04:13:56Z rgbatduke $
 *
 * See copyright in copyright.h and the accompanying file COPYING
 *========================================================================
 */

#include "dieharder.h"

void run_test()
{

 int i;

 /*
  * ========================================================================
  * This is where I'm installing the new dh_test_types[].
  * ========================================================================
  */
 if(dtest_num < 0){
   /* printf("dtest_name = %s\n",dtest_name); */
   for(i=0;i<MAXTESTS;i++){
     if(dh_test_types[i]){
       /* printf("Trying %s\n",dh_test_types[i]->sname); */
       if(strncmp(dh_test_types[i]->sname,dtest_name,128)==0){
         dtest_num = i;
	 break;
       }
     }
   }
 }
 if(dtest_num >= 0){
   execute_test(dtest_num);
 } else {
   fprintf(stderr,"Error:  dtest_num = %d.  No test found.\n",dtest_num);
   exit(1);
 }
  
}


int execute_test(int dtest_num)
{

 /*
  * Declare the results struct.
  */
 Test **dieharder_test;

 /*
  * Here we have to look at strategy FIRST.  If strategy is not zero,
  * we have to reseed either randomly or from the value of nonzero Seed.
  */
 if(strategy){
   if(Seed == 0){
     seed = random_seed();
     MYDEBUG(D_SEED){
       fprintf(stdout,"# execute_test(): Generating random seed %u\n",seed);
     }
   } else {
     seed = Seed;
     MYDEBUG(D_SEED){
       fprintf(stdout,"# execute_test(): Setting fixed seed %u\n",seed);
     }
   }
   gsl_rng_set(rng,seed);

 }

 /* printf("Test number %d: execute_test(%s) being run.\n",dtest_num,dh_test_types[dtest_num]->sname);*/

 /*
  * First we create the test (to set some values displayed in test header
  * correctly).
  */
 dieharder_test = create_test(dh_test_types[dtest_num],tsamples,psamples);

 /*
  * Set any GLOBAL data used by the test.  Then call the test itself
  * This fills in the results in the Test struct.
  */
 std_test(dh_test_types[dtest_num],dieharder_test);

 /*
  * Output standard test results.
  */
 output(dh_test_types[dtest_num],dieharder_test);

 /*
  * Destroy the test and free all dynamic memory it used.
  */
 destroy_test(dh_test_types[dtest_num],dieharder_test);

}
