/*
 * $Id: multiply.c,v 1.6 2005/03/10 15:45:10 rgb Exp $
 * See copyright in copyright.h and the accompanying file COPYING
 */

#include "benchmaster.h"

 /*
  *==================================================================
  * This is the "multiply test".  It basically measures the time
  * required to call a generic empty (multiply) function and how
  * accurately the timing harness is at determining a NET time for
  * executing its (empty) contents.
  *==================================================================
  */

void multiply_init(Test *mytest){

 mytest->vector = 0;
 mytest->ranok = 0;
 mytest->alloc = multiply_alloc;
 mytest->free = multiply_free;
 mytest->test = multiply_test;
 mytest->results = multiply_results;
 snprintf(mytest->name,K,"multiply test");
 snprintf(mytest->about,K,"result = xtest*ytest");

 if(verbose == VERBOSE || verbose == V_INIT){
   printf("# Init for test %s\n",mytest->name);
 }

}

void multiply_alloc()
{
}

void multiply_free()
{
}

int multiply_test(int full_flag)
{

 if(full_flag != 0){
   /* Full */
   result = xtest*ytest;
   return(full_flag);
 } else {
   /* Empty */
   return(full_flag);
 }

}

void multiply_results(Test *mytest)
{

 /*
  * Any conversion or renormalization should happen here, but
  * the actual output line should be the same for all tests.
  */
 mytest->avg_time = fabs(mytest->avg_time_full - mytest->avg_time_empty);
 mytest->sigma = (mytest->sigma_time_full + mytest->sigma_time_empty);
 mytest->min_time = fabs(mytest->min_time - mytest->avg_time_empty);
 mytest->max_time = fabs(mytest->max_time - mytest->avg_time_empty);
 mytest->avg_megarate = 1000.0/mytest->avg_time;
 mytest->max_megarate = 1000.0/mytest->min_time;
 mytest->min_megarate = 1000.0/mytest->max_time;

 show_results(mytest);

}

