/*
 * $Id: mflops.c,v 1.12 2005/03/10 15:45:09 rgb Exp $
 * See copyright in copyright.h and the accompanying file COPYING
 */

#include "benchmaster.h"

 /*
  *==================================================================
  * This is computes bogomegaflops (average of all four arithmetic
  * averages over a vector operation).
  *==================================================================
  */

void mflops_init(Test *mytest){

 int i;

 mytest->vector = 1;
 mytest->ranok = 0;
 mytest->alloc = mflops_alloc;
 mytest->free = mflops_free;
 mytest->test = mflops_test;
 mytest->results = mflops_results;
 snprintf(mytest->name,K,"bogomflops");
 snprintf(mytest->about,K,"d[i] = (ad + d[i])*(bd - d[i])/d[i] (%d byte double vector)",sizeof(double));

 if(verbose == VERBOSE || verbose == V_INIT){
   printf("# Init for test %s\n",mytest->name);
 }

}

void mflops_alloc()
{

 int i;

 /*
  * Allocate vector(s) to be tested with and initialize it and all
  * associated test-specific variables.
  */
 d = (double *) malloc((size_t) (size*sizeof(double)));
 /* xtest is set from the command line, default PI */
 ad = xtest;
 bd = 1.0 + xtest;
 /* Initialize the vector */
 for(i=0;i<size;i+=stride){
   d[i] = xtest;
 }

}

void mflops_free()
{

 int i;

 /*
  * Free all the memory we just allocated, to be neat and clean and
  * all that.
  */
 free(d);

}

int mflops_test(int full_flag)
{

 int i;
 
 if(full_flag){
   for(i=0;i<size;i+=stride){
     d[i] = (ad + d[i])*(bd - d[i])/d[i];
   }
   return(full_flag);
 } else {
   return(full_flag);
 }

}

void mflops_results(Test *mytest)
{

 /*
  * Any conversion or renormalization should happen here, but
  * the actual output line should be the same for all tests.
  */

 /*
  * This is the number of floating point operations in the core loop
  */
 double nanotime_norm = 4.0*size/(double)stride;

 mytest->avg_time = fabs(mytest->avg_time_full - mytest->avg_time_empty)/nanotime_norm;
 mytest->sigma = (mytest->sigma_time_full + mytest->sigma_time_empty)/nanotime_norm;
 mytest->min_time = fabs(mytest->min_time - mytest->avg_time_empty)/nanotime_norm;
 mytest->max_time = fabs(mytest->max_time - mytest->avg_time_empty)/nanotime_norm;
 mytest->avg_megarate = 1000.0/mytest->avg_time;
 mytest->max_megarate = 1000.0/mytest->min_time;
 mytest->min_megarate = 1000.0/mytest->max_time;

 show_results(mytest);

}

