/*
 *========================================================================
 * $Id: test.h,v 1.9 2005/03/10 17:54:56 rgb Exp $
 *
 * See copyright in copyright.h and the accompanying file COPYING
 *========================================================================
 */

#include "copyright.h"
#define K 1024
 /*
  * This is a struct for the test "object".  We may want to
  * put all the test parameters into a struct as well and put
  * the testparam object into this struct, buf for now we'll
  * leave it alone.
  *
  * Note Well that this struct has (or should have) ALL the data elements
  * that correspond to the tags filled in in benchml or used in xmlbenchd
  * to hold unpacked returns from benchml-compliant benchmark wrappings
  * of results or results that it computes/distributes from its associated
  * historical database.  We'll try to document tags below, noting that
  * there are also a few struct entries that do NOT have or need corresponding
  * tags.
  */
 typedef struct {
   /*
    * These are all pointers to constructor, destructor, execution routines
    * for test "objects" and don't need tags.
    */
   void (*alloc)();
   void (*free)();
   int (*test)(int);
   void (*results)();

   /*
    * Test descriptors
    */
   /* <name> */
   char name[K];
   /* <description> */
   char about[K];
   unsigned int vector;
   unsigned int ranok;
   unsigned int empty_iter;
   /* <iter> */
   unsigned int full_iter;
   /* <size> */
   unsigned int size;
   /* <stride> */
   unsigned int stride;
   /* <samples> */
   unsigned int samples;
   /*
    * Put vector support in here.  This needs work!
    */

   /*
    * Test results
    */
   double avg_time_empty;
   double avg_time2_empty;
   double sigma_time_empty;
   double avg_time_full;
   double avg_time2_full;
   double sigma_time_full;
   /* <time> */
   double avg_time;
   /* <stddev> */
   double sigma;
   /* <max_time> */
   double max_time;
   /* <min_time> */
   double min_time;
   /* <rate> */
   double avg_megarate;
   /* <max_rate> */
   double max_megarate;
   /* <min_rate> */
   double min_megarate;
 } Test;

