/*
 *========================================================================
 * $Id: startup.c,v 1.38 2005/03/10 15:53:14 rgb Exp $
 *
 * See copyright in copyright.h and the accompanying file COPYING
 *========================================================================
 */

/*
 *========================================================================
 * This routine does all the required initialization and startup,
 * including memory allocation and prefilling of vectors.  It is
 * COMPLETELY outside the timing loops.
 *========================================================================
 */

#include "benchmaster.h"

void startup()
{

 int i,j,k;
 const gsl_rng_type *T;
 unsigned int random_max,seed;

 if(verbose == VERBOSE || verbose == V_STARTUP){
   printf("# startup(): Entering startup(), use -v %d to focus\n",V_STARTUP);
 }
 if(testnum >= N_TESTS){
   fprintf(stderr,"I'm sorry, Dave, but I don't understand that test yet.\n");
   exit(0);
 }

 gsl_rng_env_setup();
 T = gsl_rng_default;
 myrandom = gsl_rng_alloc (T);
 random_max = gsl_rng_max(myrandom);
 seed = random_seed();
 gsl_rng_set(myrandom,seed);
 if(verbose == VERBOSE || verbose == V_STARTUP){
   printf("# startup(): Initialized gsl generator %s with seed %ul\n", gsl_rng_name(myrandom),seed);
 }

 /*
  * Select and set the timer we're going to use.
  */
 if(usegettimeofday){
   nanotimer_gttod_init(&nanotimer);
 } else {
   nanotimer_rdtsc_init(&nanotimer);
 }
 /*
  * The following is the autotuned minimum time spent in repeating the
  * timing loop.  It should be less than 1/2 the clock interrupt (typically
  * 0.01 seconds.  A safe value should be 0.002 seconds, which is much
  * smaller than that but around 1000x the typical time resolution of
  * system gettimeofday and around 20000x the time resolution of the
  * cpu clock nanotimer.  In nanoseconds, this is 2.0e+6.
  *
  * We WILL have to bump this limit when timing things that TAKE longer
  * than this if we also plan to use this to reject bad samples.
  */
 time_limit_base = 1.0e+6;

 ytest = xtest*1.01;
 result = xtest*1.01;

 if(verbose == VERBOSE || verbose == V_STARTUP){
   printf("# startup(): nanotimer initialized, using %s\n",nanotimer.name);
 }

 init_hostinfo();
 if(verbose == VERBOSE || verbose == V_STARTUP){
   printf("# startup(): hostinfo initialized.\n");
 }
 if(testnum == -1 && list_flag == 0){
   create_benchml();
   create_hostinfo();
   destroy_benchml();
   exit(0);
 }


 test = (Test *)malloc((size_t) (N_TESTS+1)*sizeof(Test));
 if(verbose == VERBOSE || verbose == V_STARTUP){
   printf("# startup(): Allocated test list vector.  Filling it in.\n");
 }
 /*
  * Initialize all tests here (it is cheap, don't worry) so that we can
  * eventually make this interactive and to make it easy to e.g. print
  * out a list of all supported tests.  Use the enums as shown to make
  * it easy to rearrange the order of tests in the output list (simply
  * rearrange the order of the enumerated list in tests.h).
  */
 null_init(&test[NULLTEST]);
 mflops_init(&test[MFLOPS]);
 stream_copy_init(&test[STREAM_COPY]);
 stream_scale_init(&test[STREAM_SCALE]);
 stream_add_init(&test[STREAM_ADD]);
 stream_triad_init(&test[STREAM_TRIAD]);
 mem_read_write_init(&test[MEM_READ_WRITE]);
 mem_read_init(&test[MEM_READ]);
 mem_write_init(&test[MEM_WRITE]);
 savage_init(&test[SAVAGE]);
 square_root_init(&test[SQUARE_ROOT]);
 multiply_init(&test[MULTIPLY]);
 divide_init(&test[DIVIDE]);
 timenano_init(&test[TIMENANO]);
 timesleep_init(&test[TIMESLEEP]);
 /* Can't do this until we get here, can we... */
 if(list_flag){
   list_tests();
   exit(0);
 }

 if(verbose){
   printf("# startup(): Exiting startup()\n");
 }

}
