/*
* $Id: savage.c,v 1.5 2005/03/10 15:45:10 rgb Exp $
*
* See copyright in copyright.h and the accompanying file COPYING
*
*/

#include "benchmaster.h"

 /*
  *==================================================================
  * This is the "savage" transcendental benchmark.  It ignores size
  * and stride -- it just microtimes a particular collection of
  * transcendental function calls to give one some idea of how
  * efficiently certain libm functions are implemented and whether or
  * not there is hardware support for same.
  *==================================================================
  */

void savage_init(Test *mytest){

 int i;

 mytest->vector = 0;
 mytest->ranok = 0;
 mytest->alloc = savage_alloc;
 mytest->free = savage_free;
 mytest->test = savage_test;
 mytest->results = savage_results;
 snprintf(mytest->name,K,"savage");
 snprintf(mytest->about,K,"xtest = tan(atan(exp(log(sqrt(xtest*xtest)))))");

 if(verbose == VERBOSE || verbose == V_INIT){
   printf("# Init for test %s\n",mytest->name);
 }

}

void savage_alloc()
{
}

void savage_free()
{
}

int savage_test(int full_flag)
{
 int i;
 double savage;

 if(full_flag){
   /* Full */
   savage = tan(atan(exp(log(sqrt(xtest*xtest)))));
   savage = tan(atan(exp(log(sqrt(xtest*xtest)))));
   return(full_flag);
 } else {
   /* Empty */
   savage = tan(atan(exp(log(sqrt(xtest*xtest)))));
   return(full_flag);
 }
}

void savage_results(Test *mytest)
{

 double nanotime_norm;

 /*
  * This is basically the number of core loop executions of the savage
  * line.  Note that size/stride are irrelevant.
  */
 mytest->avg_time = fabs(mytest->avg_time_full - mytest->avg_time_empty);
 mytest->sigma = (mytest->sigma_time_full + mytest->sigma_time_empty);
 mytest->min_time = fabs(mytest->min_time - mytest->avg_time_empty);
 mytest->max_time = fabs(mytest->max_time - mytest->avg_time_empty);
 mytest->avg_megarate = 1000.0/mytest->avg_time;
 mytest->max_megarate = 1000.0/mytest->min_time;
 mytest->min_megarate = 1000.0/mytest->max_time;

 show_results(mytest);

}

