/*
 *========================================================================
 * $Id: random_seed.c,v 1.2 2004/12/16 20:08:06 rgb Exp $
 *
 * See copyright in copyright.h and the accompanying file COPYING
 *========================================================================
 */

/*
 *========================================================================
 * This routine does all the required initialization and startup,
 * including memory allocation and prefilling of vectors.  It is
 * COMPLETELY outside the timing loops.
 *========================================================================
 */
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <time.h>

unsigned long int random_seed()
{

 unsigned int seed;
 struct timeval tv;
 FILE *devurandom;

 /*
  * Use /dev/urandom to get seed if possible, but go ahead and take
  * the clock if not.  At least it is likely unique, if not particularly
  * "random".  We use urandom as it will not block.
  */
 if ((devurandom = fopen("/dev/urandom","r")) == NULL) {
   gettimeofday(&tv,0);
   seed = tv.tv_sec + tv.tv_usec;
 } else {
   fread(&seed,sizeof(seed),1,devurandom);
   fclose(devurandom);
 }

 return(seed);

}
