/*
 * $Id: parsecl.c,v 1.21 2005/03/09 23:10:34 rgb Exp $
 *
 * See copyright in copyright.h and the accompanying file COPYING
 *
 */

#include "benchmaster.h"

void parsecl(int argc, char **argv)
{
 int imax,i,c,errflg=0;
 extern char *optarg;
 extern int optind, opterr, optopt;

 /*
  * Save argv.  We don't need it segmented, though -- a single string for
  * command and a second one for the entire args string is fine.
  * Note that this is a TINY bit sloppy as we don't check the length of
  * argv relative to args.  Really I should probably us snprintf and
  * strlen to ensure that I don't overrun the args buffer.  strncat
  * doesn't quite do the right thing.
  *
  * In reality I think there is a length constraint on argv anyway in
  * unix/linux, so it probably doesn't matter.
  */
 snprintf(command,K,"%s",argv[0]);
 snprintf(args,K,"");
 for(i=1;i<argc;i++){
   strcat(args,argv[i]);
   if(i < argc-1) strcat(args," ");
 }

 samples = 100;		/* Should NOT be a "lot", 10-100 is plenty */
 best_flag = NO;        /* If YES, use the BEST time to get a rate */
 iterations = -1;	/* This should be just enough to do empty accurately */
 list_flag = 0;         /* Do not list all tests unless asked nicely */
 size = 1000;		/* Small enough to easily fit into any cache */
 stride = 1;		/* Vector stride used */
 random_flag = 0;	/* Default is to NOT shuffle/randomize vector ops */
 verbose = 0;		/* Default is to be a bit noisy (debugging control). */
 quiet = 0;		/* Default is NOT to be quiet (output control). */
 xtest = PI;		/* Default is PI to many digits */
 testnum = -1;		/* Default is no test at all -- print Usage */
 usegettimeofday = 0;   /* Default is to NOT use gettimeofday timer */

 while ((c = getopt(argc,argv,"bcd:fghi:ln:qrs:t:v:x:")) != EOF){
   switch (c){
     case 'b':
       best_flag = YES;
       break;
     case 'd':
       stride = strtol(optarg,(char **) NULL,10);
       break;
     case 'g':
       usegettimeofday = 1;
       break;
     case 'h':
       Usage();
       exit(0);
       break;
     case 'i':
       iterations = strtol(optarg,(char **) NULL,10);
       break;
     case 'l':
       list_flag = 1;   /* We actually do this later */
       break;
     case 'n':
       samples = strtol(optarg,(char **) NULL,10);
       break;
     case 'q':
       quiet = 1;
       break;
     case 'r':
       random_flag = 1;
       break;
     case 's':
       size = strtol(optarg,(char **) NULL,10);
       break;
     case 't':
       testnum = strtol(optarg,(char **) NULL,10);
       break;
     case 'v':
       verbose = strtol(optarg,(char **) NULL,10);
       printf("Verbose is now %d\n",verbose);
       break;
     case 'x':
       xtest = strtod(optarg,(char **) NULL);
       break;
     case '?':
       errflg++;
   }
 }

 /*
  * If there are no more arguments, we are done.
  */
 if(argc-optind == 0){
   return;
 }

 /*
  * Anything else left is an erroneous call and should cause the Usage
  * message to be printed.  memtest -h or --help will therefore "work".
  */

 Usage();

}

void Usage()
{


 printf("\n\
Usage:\n\
   benchmaster [-t testnumber] [-l] [-s size] [-d stride] [-n num_samples]\n\
            [-i iterations] [-x xtest] [-r] [-b]\n\
	    [-v verbosity] [-q] [-h]\n\
============================================================================\n\
   benchmaster with no arguments outputs the host header only.\n\
\n\
   -t testnumber selects a test to be timed.\n\
   -l lists all currently known tests by number (for use with -t).\n\
   -s controls the size of the double vector.  This allows one to \n\
      observe the effects of L1 and L2 cache size on the result.\n\
   -d controls the delta/stride used to step through vector sizes. \n\
   -n controls the number of test samples (default 100).\n\
   -i controls the number of iterations inside the sampling loop.\n\
      If omitted, iterations are automatically scaled (best).\n\
   -x xtest allows one to set the x used in the vector (and hence to divide).\n\
      Powers of 2 are anomalously optimized on some architectures.\n\
   -r causes a vector test to use shuffled order, if enabled.\n\
   -b uses the best time, not the mean time, to make the megarate.\n\
   -q selects \"quiet\" operation: results only are printed on a single line.\n\
   -v verbosity controls selectable debugging output.\n\
   -h prints usage statement (this message) and exits.\n\
\n\
   NOTE WELL:  The \"Mega-rates\" returned by this tool are BOGUS\n\
   and may not be even approximately correct.  Be Warned!\n\
============================================================================\n\
");

 exit(0);

}

