/*
 *========================================================================
 * $Id: nanotimer.h,v 1.1 2003/06/10 15:41:27 rgb Exp $
 *
 * See copyright in copyright.h and the accompanying file COPYING
 *========================================================================
 */

#include "copyright.h"
#define K 1024

 /*
  * The following are the struct components of the timer(s).  They
  * should let us write one bit of code and use it with either
  * timer transparently.
  */
 typedef struct {
   double (*timer)();
   double start;
   double stop;
   double delta;
   double nsec_granularity;
   char name[K];
 } Nanotimer;

 /*
  * Built in cycle counter timer (Intel or AMD) resolution
  * roughly 1 CPU clock (sub-nanosecond on modern CPUs).
  */
 static double nsec_per_cycle;
 static unsigned long ax_first,dx_first;
 static unsigned long long count_first;

 void nanotimer_rdtsc_init(Nanotimer *new_nanotimer);
 double nanotimer_rdtsc();

 /*
  * Fallback timer using gettimeofday.  Resolution of roughly
  * 2 usec on a good day, but the way we scale test intervals
  * it doesn't usually matter.
  */
 static struct timeval tv_first;

 void nanotimer_gttod_init(Nanotimer *nanotimer);
 double nanotimer_gttod();
