/*
* $Id: mem_read_write.c,v 1.11 2005/03/10 15:45:09 rgb Exp $
*
* See copyright in copyright.h and the accompanying file COPYING
*
*/

#include "benchmaster.h"

 /*
  *==================================================================
  * This is the sequential or random read/write "memtest" benchmark, 
  * wrapped up in this timing engine and fitted with a variable stride.
  *==================================================================
  */

void mem_read_write_init(Test *mytest){

 int i;

 mytest->vector = 1;
 mytest->ranok = 1;
 mytest->alloc = mem_read_write_alloc;
 mytest->free = mem_read_write_free;
 mytest->test = mem_read_write_test;
 mytest->results = mem_read_write_results;
 snprintf(mytest->name,K,"memory read/write");
 snprintf(mytest->about,K,"Reads, then writes %d byte integer vector",sizeof(int));

 if(verbose == VERBOSE || verbose == V_INIT){
   printf("# Init for test %s\n",mytest->name);
 }

}

void mem_read_write_alloc()
{

 int i;

 /*
  * Allocate vector(s) to be tested with and initialize it and all
  * associated test-specific variables.
  */
 ai = (unsigned int *) malloc((size_t) (size*sizeof(unsigned int)));
 /* Initialize the vector */
 for(i=0;i<size;i+=stride){
   ai[i] = i;
 }

 if(verbose == VERBOSE || verbose == V_INIT){
   printf("#==================================================================\n");
   for(i=0;i<size;i++) printf("# mem_read_write(): Unshuffled: ai[%d] = %u\n",i,ai[i]);
   printf("#========================================================================\n");
 }

}

void mem_read_write_free()
{

 int i;

 /*
  * Free all the memory we just allocated, to be neat and clean and
  * all that.
  */
 free(ai);

}

int mem_read_write_test(int full_flag)
{
 int i;
 if(full_flag){
   /* Full */
   for(i=0; i<size; i+=stride){
     aindex = ai[i];
     aitmp = ai[aindex];
     ai[aindex] = aitmp;
   }
   return(full_flag);
 } else {
   /* Empty */
   for(i=0; i<size; i+=stride){
     aindex = ai[i];
   }
   return(full_flag);
 }
}

void mem_read_write_results(Test *mytest)
{

 double nanotime_norm;

 /*
  * This is basically the number of core loop executions
  */
 nanotime_norm = size/(double)stride;

 mytest->avg_time = fabs(mytest->avg_time_full - mytest->avg_time_empty)/nanotime_norm;
 mytest->sigma = (mytest->sigma_time_full + mytest->sigma_time_empty)/nanotime_norm;
 mytest->min_time = fabs(mytest->min_time - mytest->avg_time_empty)/nanotime_norm;
 mytest->max_time = fabs(mytest->max_time - mytest->avg_time_empty)/nanotime_norm;
 mytest->avg_megarate = 1000.0/mytest->avg_time;
 mytest->max_megarate = 1000.0/mytest->min_time;
 mytest->min_megarate = 1000.0/mytest->max_time;


 show_results(mytest);

}

