/*
 * $Id: divide.c,v 1.5 2005/03/10 15:45:09 rgb Exp $
 * See copyright in copyright.h and the accompanying file COPYING
 */

#include "benchmaster.h"

 /*
  *==================================================================
  * This is the "divide test".  It basically measures the time
  * required to call a generic empty (divide) function and how
  * accurately the timing harness is at determining a NET time for
  * executing its (empty) contents.
  *==================================================================
  */

void divide_init(Test *mytest){

 mytest->vector = 0;
 mytest->ranok = 0;
 mytest->alloc = divide_alloc;
 mytest->free = divide_free;
 mytest->test = divide_test;
 mytest->results = divide_results;
 snprintf(mytest->name,K,"divide test");
 snprintf(mytest->about,K,"result = xtest/ytest");

 if(verbose == VERBOSE || verbose == V_INIT){
   printf("# Init for test %s\n",mytest->name);
 }

}

void divide_alloc()
{
}

void divide_free()
{
}

int divide_test(int full_flag)
{

 if(full_flag != 0){
   /* Full */
   result = xtest/ytest;
   return(full_flag);
 } else {
   /* Empty */
   return(full_flag);
 }

}

void divide_results(Test *mytest)
{

 /*
  * Any conversion or renormalization should happen here, but
  * the actual output line should be the same for all tests.
  */
 mytest->avg_time = fabs(mytest->avg_time_full - mytest->avg_time_empty);
 mytest->sigma = mytest->sigma_time_full + mytest->sigma_time_empty;
 mytest->min_time = fabs(mytest->min_time - mytest->avg_time_empty);
 mytest->max_time = fabs(mytest->max_time - mytest->avg_time_empty);
 mytest->avg_megarate = 1000.0/mytest->avg_time;
 mytest->max_megarate = 1000.0/mytest->min_time;
 mytest->min_megarate = 1000.0/mytest->max_time;

 show_results(mytest);

}

