/*
 *========================================================================
 * $Id: cpuinfo.c 87 2004-09-28 17:31:03Z rgb $
 *
 * See copyright in copyright.h and the accompanying file COPYING
 *========================================================================
 */

#include <wulfware/libwulf.h>

/*
 * <cpuinfo> tag init and update (same thing)
 */
void init_cpuinfo(Host *hostptr)
{

 /* scratch buffer for attributes */
 char attr_buf[K];

 /* Cpu pointer */
 Cpu *cpuptr;

 /* 
  * scratch: current timestamp and delta (to microsecond resolution) 
  */
 unsigned long seconds,useconds;

 if((verbose == D_ALL) || (verbose == D_INIT_VALUES)){
   fprintf(OUTFP,"D_INIT_VALUES: Starting init_cpuinfo().  Use -v %d to focus.\n",D_INIT_VALUES);
   
 }

 /* 
  * cpuinfo - tv_sec and tv_usec timestamps.
  */
 /* <cpuinfo tv_sec=?> */
 if(xtract_attribute(UNSIGNED_LONG,&seconds,value_xpath[CPUINFO],
                      "tv_sec",hostptr->xp_doc) > 1){
   fprintf(OUTFP,"fill_values() Warning: %s not unique content tag.\n",
         value_xpath[CPUINFO]);
 }
 if((verbose == D_ALL) || (verbose == D_UPDATE_VALUES)){
   fprintf(OUTFP,"D_UPDATE_VALUES: seconds = %d\n",seconds);
 }
 hostptr->val.cpuinfo_tv_sec = seconds;

 /* <cpuinfo tv_usec=?> */
 if(xtract_attribute(UNSIGNED_LONG,&useconds,value_xpath[CPUINFO],
                      "tv_usec",hostptr->xp_doc) > 1){
   fprintf(OUTFP,"fill_values() Warning: %s not unique content tag.\n",
         value_xpath[CPUINFO]);
 }
 if((verbose == D_ALL) || (verbose == D_UPDATE_VALUES)){
   fprintf(OUTFP,"D_UPDATE_VALUES: useconds = %d\n",useconds);
 }
 hostptr->val.cpuinfo_tv_usec = useconds;
 if((verbose == D_ALL) || (verbose == D_UPDATE_VALUES)){
   fprintf(OUTFP,"D_UPDATE_VALUES: cpuinfo_tv_sec = %ul cpuinfo_tv_usec = %ul\n",hostptr->val.cpuinfo_tv_sec,hostptr->val.cpuinfo_tv_usec);
 }

 /*
  * cpuinfo stuff.  First model name
  */
 if( xtract(STRING,hostptr->val.cpuinfo_model_name,value_xpath[CPUINFO_MODEL_NAME],hostptr->xp_doc) > 1){
   fprintf(OUTFP,"fill_values() Warning: %s not unique content tag.\n",value_xpath[CPUINFO_MODEL_NAME]);
 }
 if((verbose == D_ALL) || (verbose == D_UPDATE_VALUES)){
   fprintf(OUTFP,"D_UPDATE_VALUES: CPU model name = %s\n",hostptr->val.cpuinfo_model_name);
 }
      
 /*
  * Next, cpu clock.  Need units attribute first, in a generic buffer.
  */
 if(xtract_attribute(STRING,attr_buf,value_xpath[CPUINFO_CLOCK],"units",hostptr->xp_doc) > 1){
   fprintf(OUTFP,"fill_values() Warning: %s not unique content tag.\n",value_xpath[CPUINFO_CLOCK]);
 }
 if((verbose == D_ALL) || (verbose == D_UPDATE_VALUES)){
   fprintf(OUTFP,"D_UPDATE_VALUES: Units of cpu clock are %s\n",attr_buf);
 }
 if(xtract(DOUBLE,&hostptr->val.cpuinfo_clock,value_xpath[CPUINFO_CLOCK],
         hostptr->xp_doc) > 1){
    fprintf(OUTFP,"fill_values() Warning: %s not unique content tag.\n",
         value_xpath[CPUINFO_CLOCK]);
 }
 if(strncmp(attr_buf,"GHz",3) == 0){
   hostptr->val.cpuinfo_clock /= 1000.0;
 }
 if((verbose == D_ALL) || (verbose == D_UPDATE_VALUES)){
   fprintf(OUTFP,"D_UPDATE_VALUES: CPU clock = %8.3f MHz\n",hostptr->val.cpuinfo_clock);
 }
 /*
  * Finally, cpu cachesize.
  */
 if(xtract_attribute(STRING,attr_buf,value_xpath[CPUINFO_CACHESIZE],
                  "units",hostptr->xp_doc) > 1){
   fprintf(OUTFP,"fill_values() Warning: %s not unique content tag.\n",
       value_xpath[CPUINFO_CACHESIZE]);
 }
 if((verbose == D_ALL) || (verbose == D_UPDATE_VALUES)){
    fprintf(OUTFP,"D_UPDATE_VALUES: Units of cpu cachesize are %s\n",attr_buf);
 }
 if(xtract(LONG,&hostptr->val.cpuinfo_cachesize,value_xpath[CPUINFO_CACHESIZE],
         hostptr->xp_doc) > 1){
   fprintf(OUTFP,"fill_values() Warning: %s not unique content tag.\n",
         value_xpath[CPUINFO_CACHESIZE]);
 }
 if(strncmp(attr_buf,"MB",3) == 0){
   hostptr->val.cpuinfo_cachesize *= 1000;
 }
 if((verbose == D_ALL) || (verbose == D_UPDATE_VALUES)){
   fprintf(OUTFP,"D_UPDATE_VALUES: CPU cachesize = %d KB\n",hostptr->val.cpuinfo_cachesize);
 }

}


void update_cpuinfo(Host *hostptr)
{

 /* scratch buffer for attributes */
 char attr_buf[K];

 /* Cpu pointer */
 Cpu *cpuptr;

 /* 
  * scratch: current timestamp and delta (to microsecond resolution) 
  */
 unsigned long seconds,useconds;

 if((verbose == D_ALL) || (verbose == D_INIT_VALUES)){
   fprintf(OUTFP,"D_INIT_VALUES: Starting init_cpuinfo().  Use -v %d to focus.\n",D_INIT_VALUES);
   
 }

 /* 
  * cpuinfo - tv_sec and tv_usec timestamps.
  */
 /* <cpuinfo tv_sec=?> */
 if(xtract_attribute(UNSIGNED_LONG,&seconds,value_xpath[CPUINFO],
                      "tv_sec",hostptr->xp_doc) > 1){
   fprintf(OUTFP,"fill_values() Warning: %s not unique content tag.\n",
         value_xpath[CPUINFO]);
 }
 if((verbose == D_ALL) || (verbose == D_UPDATE_VALUES)){
   fprintf(OUTFP,"D_UPDATE_VALUES: seconds = %d\n",seconds);
 }
 hostptr->val.cpuinfo_tv_sec = seconds;

 /* <cpuinfo tv_usec=?> */
 if(xtract_attribute(UNSIGNED_LONG,&useconds,value_xpath[CPUINFO],
                      "tv_usec",hostptr->xp_doc) > 1){
   fprintf(OUTFP,"fill_values() Warning: %s not unique content tag.\n",
         value_xpath[CPUINFO]);
 }
 if((verbose == D_ALL) || (verbose == D_UPDATE_VALUES)){
   fprintf(OUTFP,"D_UPDATE_VALUES: useconds = %d\n",useconds);
 }
 hostptr->val.cpuinfo_tv_usec = useconds;
 if((verbose == D_ALL) || (verbose == D_UPDATE_VALUES)){
   fprintf(OUTFP,"D_UPDATE_VALUES: cpuinfo_tv_sec = %ul cpuinfo_tv_usec = %ul\n",hostptr->val.cpuinfo_tv_sec,hostptr->val.cpuinfo_tv_usec);
 }

 /*
  * cpuinfo stuff.  First model name
  */
 if( xtract(STRING,hostptr->val.cpuinfo_model_name,value_xpath[CPUINFO_MODEL_NAME],hostptr->xp_doc) > 1){
   fprintf(OUTFP,"fill_values() Warning: %s not unique content tag.\n",value_xpath[CPUINFO_MODEL_NAME]);
 }
 if((verbose == D_ALL) || (verbose == D_UPDATE_VALUES)){
   fprintf(OUTFP,"D_UPDATE_VALUES: CPU model name = %s\n",hostptr->val.cpuinfo_model_name);
 }
      
 /*
  * Next, cpu clock.  Need units attribute first, in a generic buffer.
  */
 if(xtract_attribute(STRING,attr_buf,value_xpath[CPUINFO_CLOCK],"units",hostptr->xp_doc) > 1){
   fprintf(OUTFP,"fill_values() Warning: %s not unique content tag.\n",value_xpath[CPUINFO_CLOCK]);
 }
 if((verbose == D_ALL) || (verbose == D_UPDATE_VALUES)){
   fprintf(OUTFP,"D_UPDATE_VALUES: Units of cpu clock are %s\n",attr_buf);
 }
 if(xtract(DOUBLE,&hostptr->val.cpuinfo_clock,value_xpath[CPUINFO_CLOCK],
         hostptr->xp_doc) > 1){
    fprintf(OUTFP,"fill_values() Warning: %s not unique content tag.\n",
         value_xpath[CPUINFO_CLOCK]);
 }
 if(strncmp(attr_buf,"GHz",3) == 0){
   hostptr->val.cpuinfo_clock /= 1000.0;
 }
 if((verbose == D_ALL) || (verbose == D_UPDATE_VALUES)){
   fprintf(OUTFP,"D_UPDATE_VALUES: CPU clock = %8.3f MHz\n",hostptr->val.cpuinfo_clock);
 }
 /*
  * Finally, cpu cachesize.
  */
 if(xtract_attribute(STRING,attr_buf,value_xpath[CPUINFO_CACHESIZE],
                  "units",hostptr->xp_doc) > 1){
   fprintf(OUTFP,"fill_values() Warning: %s not unique content tag.\n",
       value_xpath[CPUINFO_CACHESIZE]);
 }
 if((verbose == D_ALL) || (verbose == D_UPDATE_VALUES)){
    fprintf(OUTFP,"D_UPDATE_VALUES: Units of cpu cachesize are %s\n",attr_buf);
 }
 if(xtract(LONG,&hostptr->val.cpuinfo_cachesize,value_xpath[CPUINFO_CACHESIZE],
         hostptr->xp_doc) > 1){
   fprintf(OUTFP,"fill_values() Warning: %s not unique content tag.\n",
         value_xpath[CPUINFO_CACHESIZE]);
 }
 if(strncmp(attr_buf,"MB",3) == 0){
   hostptr->val.cpuinfo_cachesize *= 1000;
 }
 if((verbose == D_ALL) || (verbose == D_UPDATE_VALUES)){
   fprintf(OUTFP,"D_UPDATE_VALUES: CPU cachesize = %d KB\n",hostptr->val.cpuinfo_cachesize);
 }

}
