/*
 *========================================================================
 * $Id: cpu_rate.h,v 1.13 2003/02/09 14:22:23 rgb Exp $
 *
 * See copyright in copyright.h and the accompanying file COPYING
 *========================================================================
 */

#include "copyright.h"

#include <stdio.h>
#include <stdlib.h>
#include <sys/time.h>
#include <unistd.h>
#include <math.h>
#include <string.h>
#include <gsl/gsl_rng.h>

/*
 *========================================================================
 * Useful defines
 *========================================================================
 */

#define STDIN	stdin
#define STDOUT	stdout
#define STDERR	stderr
#define YES	1
#define NO	0
#define PI 3.141592653589793238462643
#define K       1024

/*
 * Can choose between two timers, gettimeofday() (relatively coarse
 * at roughly 2 usec granularity per call) and the tsc cpu clock timer
 * on Intel/AMD chips (good to perhaps 40-50 nsec).
 *
 * Where one has it, the latter is obviously better but both yield the
 * same answers whereever I test
 */
/* #define NANOTIMER() gettimeofday_nanotimer() */
#define NANOTIMER() nanotimer()

 /*
  *========================================================================
  * Subroutine Prototypes
  *========================================================================
  */
 unsigned int makeseed();
 void start_timing();
 void stop_timing();
 double delta_timing();
 void measure_rate();
 void Usage();
 unsigned long long gettsc(void);
 unsigned long long fast_gettsc(void);
 double init_nanotimer();
 double nanotimer();
 double gettimeofday_nanotimer();

 /*
  *========================================================================
  * Global Variables:
  *      samples is the number of samples to be taken
  *      iterations is the number of times the core loop is run (inserted 
  *        so one can minimize errors due to the gettimeofday call itself).
  *      random_flag controls the insertion of usleep(1), probably cruft
  *        as it makes little visible difference EXCEPT in the empty
  *        timing loop (where it is essential and not controlled by
  *        random_flag!).
  *      cache_flag is an experimental control.
  *      xtest is an input variable used to pass the d[i] (and hence
  *        division) variable from the command line.
  *      size is the length of the vector being evaluated.
  *      verbose controls the output -- "normal" is verbose=1.
  *      tv_start and tv_stop are used to record timings.
  *
  *      floattest selects a straight bogomflops run
  *      doubletest selects a double precision bogomflops run (bogomdops?)
  *========================================================================
  */
 int samples,iterations,stride,random_flag,cache_flag,size;
 int quiet,verbose;
 int floattest,doubletest,transtest;
 int testnum;
 struct timeval tv_start,tv_stop;

 /*
  * Global vectors and constants for tests.
  */
 double xtest;			/* input variable */
 int dummy,idiot;		/* To fool compiler into executing empty cases */
 int *myindex;		        /* re-indexing/shuffling vector */
 double *a,*b,*c,*d,*e;		/* To test double floats */
 double ad,bd,cd,dd,ed;		/* double variables */
 unsigned int *ai,aindex,aitmp; /* To do memtest on unsigned int vectors */
 double nanotime_start,nanotime_stop,nanotime_delta,nsec_granularity;

 gsl_rng *myrandom;  /* global gsl random number generator */
 FILE *fp;         /* pointer to /dev/random, for that benchmark or rng seed */


