/*
 *========================================================================
 * $Id: tests.h,v 1.7 2004/06/15 05:12:36 rgb Exp $
 *
 * See copyright in copyright.h and the accompanying file COPYING
 *========================================================================
 */

#include "copyright.h"

 /*
  * Each test should be in its own directory with its own matched
  * include file.  The include file should be added to the list below.
  * It is a VERY GOOD IDEA to maintain the same order here and
  * in the accompanying enumerated lists and in the order in which
  * the test names/indices are loaded into the toplevel vector of
  * test structs to make it easy to track the test number.
  */
 typedef enum {
   NULLTEST,
   MFLOPS,
   MTRIDS,
   STREAM_COPY,
   STREAM_SCALE,
   STREAM_ADD,
   STREAM_TRIAD,
   MEM_READ_WRITE,
   MEM_READ,
   MEM_WRITE,
   SAVAGE,
   SQUARE_ROOT,
   MULTIPLY,
   DIVIDE,
   TIMENANO,
   TIMESLEEP,
   N_TESTS
 } TESTS;

#include "null_test.h"
#include "mflops.h"
#include "mtrids.h"
#include "stream_add.h"
#include "stream_copy.h"
#include "stream_scale.h"
#include "stream_triad.h"
#include "mem_read_write.h"
#include "mem_read.h"
#include "mem_write.h"
#include "savage.h"
#include "square_root.h"
#include "multiply.h"
#include "divide.h"
#include "timenano.h"
#include "timesleep.h"
