/*
 * $Id: stream_scale.c,v 1.8 2004/06/14 23:38:49 rgb Exp $
 * See copyright in copyright.h and the accompanying file COPYING
 */

#include "cpu_rate.h"

 /*
  *==================================================================
  * This is the "scale" test from the stream suite.  It is not
  * directly comparable to stream results for a variety of reasons.
  * For one, it uses malloc to allocate all vectors and consequently
  * adds one more degree of indirection to address resolution.  It
  * returns results that are SLIGHTLY LOWER/SLOWER than regular
  * stream (but which may be more realistic for general purpose code).
  *
  * It also uses a different timing harness, one that is both
  * more accurate (uses a superior timer) and which repeats the
  * computation many times to obtain both a mean and a standard
  * deviation on the test results.
  *==================================================================
  */

void stream_scale_init(Test *mytest){

 int i;

 mytest->alloc = stream_scale_alloc;
 mytest->free = stream_scale_free;
 mytest->test = stream_scale_test;
 mytest->results = stream_scale_results;
 snprintf(mytest->name,K,"stream scale");
 snprintf(mytest->about,K,"d[i] = xtest*d[i] (%d byte double vector)",sizeof(double));

 if(verbose == VERBOSE || verbose == V_INIT){
   printf("# Init for test %s\n",mytest->name);
 }

}

void stream_scale_alloc()
{

 int i;

 /*
  * Allocate vector(s) to be tested with and initialize it and all
  * associated test-specific variables.
  */
 d = (double *) malloc((size_t) (size*sizeof(double)));
 /* Initialize the vector */
 for(i=0;i<size;i+=stride){
   d[i] = 0.0;
 }

}

void stream_scale_free()
{

 int i;

 /*
  * Free all the memory we just allocated, to be neat and clean and
  * all that.
  */
 free(d);

}

int stream_scale_test(int full_flag)
{

 int i;
 
 if(full_flag){
   for(i=0;i<size;i+=stride){
     d[i] = xtest*d[i];
   }
 } else {
   return(full_flag);
 }
}

void stream_scale_results(Test *mytest)
{

 double nanotime_norm;

 /*
  * This is the number of scale operations in the core loop
  */
 nanotime_norm = (double)size/stride;

 mytest->avg_time = fabs(mytest->avg_time_full - mytest->avg_time_empty)/nanotime_norm;
 mytest->sigma = (mytest->sigma_time_full + mytest->sigma_time_empty)/nanotime_norm;
 mytest->avg_megarate = 1000.0/mytest->avg_time;

 show_results(mytest);

}

