/*
 * $Id: square_root.c,v 1.1 2004/06/14 21:26:27 rgb Exp $
 * See copyright in copyright.h and the accompanying file COPYING
 */

#include "cpu_rate.h"

 /*
  *==================================================================
  * This is the square root test.  It basically measures the time
  * required to call the generic square root function.
  *==================================================================
  */

void square_root_init(Test *mytest){

 mytest->alloc = square_root_alloc;
 mytest->free = square_root_free;
 mytest->test = square_root_test;
 mytest->results = square_root_results;
 snprintf(mytest->name,K,"square root test");
 snprintf(mytest->about,K,"result = sqrt(xtest)");

 if(verbose == VERBOSE || verbose == V_INIT){
   printf("# Init for test %s\n",mytest->name);
 }

}

void square_root_alloc()
{
}

void square_root_free()
{
}

int square_root_test(int full_flag)
{
 if(full_flag){
   result = sqrt(xtest);
   result = sqrt(xtest);
   return(full_flag);
 } else {
   result = sqrt(xtest);
   return(full_flag);
 }
}

void square_root_results(Test *mytest)
{

 /*
  * Any conversion or renormalization should happen here, but
  * the actual output line should be the same for all tests.
  */
 mytest->avg_time = fabs(mytest->avg_time_full - mytest->avg_time_empty);
 mytest->sigma = mytest->sigma_time_full + mytest->sigma_time_empty;
 mytest->avg_megarate = 1000.0/mytest->avg_time;

 show_results(mytest);

}

