/*
 *========================================================================
 * $Id: show_results.c,v 1.2 2004/06/14 21:26:27 rgb Exp $
 *
 * See copyright in copyright.h and the accompanying file COPYING
 *========================================================================
 */


#include "cpu_rate.h"

/* 
 *==================================================================
 * Utility routines
 *==================================================================
 */


char *scale_k(int k,int width,int unit) 
{

 /* kilobytes, megabytes, gigabytes, too-big-for-int-bytes */
 static double scale[]={1024,1024*1024,1024*1024*1024,0};

 /* kilo, mega, giga, tera */
 static char unitletters[]={'K','M','G','T',0};
 static char buf[128];
 char *up;
 double *dp;

 /* Try successively higher units until it fits */

 sprintf(buf,"%d",k);
 if(strlen(buf)<=width) return buf;

 for (up=unitletters+unit,dp=scale ; *dp ; ++dp,++up) {
   sprintf(buf,"%.1f%c",k / *dp,*up);
   if (strlen(buf)<=width) return buf;
   sprintf(buf,"%d%c",(int)(k / *dp),*up);
  if (strlen(buf)<=width) return buf;
 }
 /* Give up; give them what we got on our shortest attempt */
 return buf;

}

void show_results(Test *mytest)
{

 size_t i,length;
 if(!quiet){
   printf("#========================================================================\n");
   printf("#                          Microtimer %d.%.1f\n",VERSION_MAJOR,VERSION_MINOR);
   printf("#                    Copyright 2004 Robert G. Brown\n");
   printf("#\n");
   printf("# hostname: %s\n",host.hostname);
   printf("# CPU: %s %s at %s (MHz) \n",host.vendor_id,host.name,host.speed);
   printf("# CPU: L2 cache:%s    bogomips: %s\n",host.l2cache,host.bogomips);
   printf("# Memory: %s\n",scale_k(atoi(host.memory),6,0));
   printf("# %s: clock granularity (nsec/cycle) = %6.3f\n",nanotimer.name,nanotimer.nsec_granularity);
   printf("# Test: %s\n",test[testnum].name);
   printf("# Test Description: %s\n",test[testnum].about);
   printf("#\n");
   printf("# full iterations = %d    empty iterations = %d\n",
      mytest->full_iter,mytest->empty_iter);
   printf("# time full = %f (nsec)   time empty = %f (nsec)\n",
      mytest->avg_time_full,mytest->avg_time_empty);
   printf("#\n");
   printf("#    test name           vlen   stride  time +/- sigma (nsec)  megarate\n");
   printf("#========================================================================\n");
 }

 length = strlen(mytest->name);
 if(length<18){
   printf("\"%s\"",mytest->name);
 } else {
   printf("\"%18s\"",mytest->name);
 }
 for(i=0;i<18-length;i++) printf(" ");
 printf("%10d   %3d  %8.2e  %8.2e     %10.3e\n",
       size,stride,mytest->avg_time,mytest->sigma,mytest->avg_megarate);

}

