/*
 * $Id: mtrids.c,v 1.8 2004/06/14 23:38:49 rgb Exp $
 * See copyright in copyright.h and the accompanying file COPYING
 */

#include "cpu_rate.h"

 /*
  *==================================================================
  * This computes bogomegatrids, which are the average time required
  * to execute a vector +,-,* operations (note, no division.  It
  * should be very  nearly equivalent to stream triad (hence the
  * name) and if it proves redundant we'll eliminate it.
  *==================================================================
  */

void mtrids_init(Test *mytest){

 int i;

 mytest->alloc = mtrids_alloc;
 mytest->free = mtrids_free;
 mytest->test = mtrids_test;
 mytest->results = mtrids_results;
 snprintf(mytest->name,K,"bogomtrids");
 snprintf(mytest->about,K,"d[i] = (ad + bd - cd)*d[i] (%d byte double vector)",sizeof(double));

 if(verbose == VERBOSE || verbose == V_INIT){
   printf("# Init for test %s\n",mytest->name);
 }

}

void mtrids_alloc()
{

 int i;

 /*
  * Allocate vector(s) to be tested with and initialize it and all
  * associated test-specific variables.
  */
 d = (double *) malloc((size_t) (size*sizeof(double)));
 /* xtest is set from the command line, default PI */
 ad = 1.0;
 bd = xtest;
 cd = xtest;
 /* Initialize the vector */
 for(i=0;i<size;i+=stride){
   d[i] = xtest;
 }

}

void mtrids_free()
{

 int i;

 /*
  * Free all the memory we just allocated, to be neat and clean and
  * all that.
  */
 free(d);

}

int mtrids_test(int full_flag)
{

 int i;
 
 if(full_flag){
   for(i=0;i<size;i+=stride){
     d[i] = (ad + bd - cd)*d[i];
   }
   return(full_flag);
 } else {
   return(full_flag);
 }

 /*
  * Free all the memory we just allocated, to be neat and clean and
  * all that.
  */
 free(d);

}

void mtrids_results(Test *mytest)
{

 double nanotime_norm;

 /*
  * This is the number of floating point operations in the core loop
  */
 nanotime_norm = 3.0*size/(double)stride;

 mytest->avg_time = fabs(mytest->avg_time_full - mytest->avg_time_empty)/nanotime_norm;
 mytest->sigma = (mytest->sigma_time_full + mytest->sigma_time_empty)/nanotime_norm;
 mytest->avg_megarate = 1000.0/mytest->avg_time;

 show_results(mytest);

}

