/*
* $Id: measure_rate.c,v 1.43 2004/06/15 05:12:36 rgb Exp $
*
* See copyright in copyright.h and the accompanying file COPYING
*
*/

#include "cpu_rate.h"

/*
 *==================================================================
 * This is the primary timing shell.  set_iter(&test) has already
 * run preliminary loops of the test to be run to determine how
 * many times it has to be repeated to get decent timer precision
 * on the result (automagically).  Now we just run the loops both
 * empty and full.
 *==================================================================
 */

void measure_rate(Test *mytest)
{

 double total_time,total_time2;
 int i,j,k,rejections;
 struct timespec ts;
 struct timeval tv;
 double test_nanotime;

 if(verbose == V_MEASURE || verbose == VERBOSE) {
   printf("# measure_rate: Entering measure_rate() for %s.  %d to focus.\n",mytest->name,V_MEASURE);
 }

 /*
  * Always begin by allocating any space required for running THIS
  * test.
  */
 if(verbose == V_MEASURE || verbose == VERBOSE) {
   printf("# measure_rate: Entering mytest->alloc()\n");
 }
 mytest->alloc();
 
 /*
  * Measure the empty loop time.
  */
 total_time = 0.0;
 total_time2 = 0.0;
 rejections = 0;
 for(k=0;k<samples;k++){

   test_nanotime = time_empty(mytest);
/*   
   usleep(1000);
   nanotimer.start = nanotimer.timer();
   for(j=0;j<mytest->empty_iter;j++){
      mytest->test(0);
   }
   nanotimer.stop = nanotimer.timer();
   nanotimer.delta = nanotimer.stop - nanotimer.start;
*/

   /*
    * test_nanotime is now the time, in nanoseconds, of a single empty
    * test loop (including subroutine call and conditional overhead).  We
    * reject samples that are bigger than 2*time_limit_empty, as they are
    * almost certainly caused by spurious timer (or other) interrupts
    * occuring in the middle of the sampling.  Some places we might want
    * to average them in; here we don't.
    */
   if(test_nanotime > 1.05*time_limit_empty && rejections < samples){

     /*
      * Basically, "repeat the measurement".  Probably need a check
      * for an infinite loop here, in case set_iter set an irrational
      * upper time limit.
      */
     if(verbose == VERBOSE || verbose == V_MEASURE){
       test_nanotime /= mytest->empty_iter;
       printf("# measure_rate(): rejecting test time of = %e (nsec)\n",
          test_nanotime);
     }
     rejections++;
     k--;

   } else {

     test_nanotime /= mytest->empty_iter;
     if(verbose == V_MEASURE || verbose == VERBOSE) {
       printf("# measure_rate(): mytest->empty_iter = %d test time = %e (nsec)\n",mytest->empty_iter,test_nanotime);
     }
     total_time += test_nanotime;
     total_time2 += test_nanotime*test_nanotime;

   }

 }
 mytest->avg_time_empty = total_time/samples;
 mytest->avg_time2_empty = total_time2/samples;
 if(samples>1){
   mytest->sigma_time_empty = sqrt(( mytest->avg_time2_empty -
      mytest->avg_time_empty*mytest->avg_time_empty)/(samples-1.0));
 } else {
   mytest->sigma_time_empty = 1.0e300;
 }

 if(verbose == V_MEASURE || verbose == VERBOSE) {
   printf("#\n# measure_rate: test %s mean time empty = %e +/0 %e\n#\n",
      mytest->name,mytest->avg_time_empty,mytest->sigma_time_empty);
 }


 /*
  * Measure the full loop time.
  */
 total_time = 0.0;
 total_time2 = 0.0;
 rejections = 0;
 for(k=1;k<=samples;k++){
   /*
    * We need an independent shuffle for each sample, right?
    * But only in shuffle mode.
    */
   if(random_flag){
     gsl_ran_shuffle(myrandom, ai, size, sizeof (unsigned int));
     if(verbose == V_MEASURE || verbose == VERBOSE){
       printf("#==================================================================\n");
       for(i=0;i<size;i++) printf("# Shuffled: ai[%d] = %u\n",i,ai[i]);
       printf("#==================================================================\n");
     }
   }
   test_nanotime = time_full(mytest);
/*   
   usleep(1000);
   nanotimer.start = nanotimer.timer();
   for(j=1;j<=mytest->full_iter;j++){
      mytest->test(1);
   }
   nanotimer.stop = nanotimer.timer();
   nanotimer.delta = nanotimer.stop - nanotimer.start;
*/


   /*
    * test_nanotime is now the time, in nanoseconds, of a single
    * full test loop (including subroutine call and conditional overhead).
    */
   if(test_nanotime > 1.05*time_limit_full && rejections < samples){
     /*
      * Basically, "repeat the measurement".  Probably need a check
      * for an infinite loop here, in case set_iter set an irrational
      * upper time limit.
      */
     if(verbose == VERBOSE || verbose == V_MEASURE){
       printf("# measure_rate(): time_limit_full = %e full loop test time = %e (nsec)\n",
          time_limit_full,test_nanotime);
       test_nanotime /= mytest->full_iter;
       printf("# measure_rate(): rejecting test time = %e (nsec)\n",
          test_nanotime);
     }
     rejections++;
     k--;
   } else {
     test_nanotime /= mytest->full_iter;
     if(verbose == V_MEASURE || verbose == VERBOSE) {
       printf("# measure_rate: mytest->full_iter = %d test time = %e\n",mytest->full_iter,test_nanotime);
     }
     total_time += test_nanotime;
     total_time2 += test_nanotime*test_nanotime;
   }
 }
 mytest->avg_time_full = total_time/samples;
 mytest->avg_time2_full = total_time2/samples;
 if(samples>1){
   mytest->sigma_time_full = sqrt(( mytest->avg_time2_full -
      mytest->avg_time_full*mytest->avg_time_full)/(samples-1.0));
 } else {
   mytest->sigma_time_full = 1.0e300;
 }

 if(verbose == V_MEASURE || verbose == VERBOSE) {
   printf("#\n# measure_rate: test %s mean time full = %e +/0 %e\n#\n",
      mytest->name,mytest->avg_time_full,mytest->sigma_time_full);
 }

 /*
  * Always end by freeing any space allocated above for THIS test.
  */
 mytest->free();
 
}
