/*
 *========================================================================
 * $Id: cpu_rate.h,v 1.37 2004/06/15 05:12:36 rgb Exp $
 *
 * See copyright in copyright.h and the accompanying file COPYING
 *========================================================================
 */

#include "copyright.h"

#include <stdio.h>
#include <stdlib.h>
#include <sys/time.h>
#include <unistd.h>
#include <math.h>
#include <string.h>
#include <gsl/gsl_rng.h>

#include "nanotimer.h"
#include "test.h"
#include "tests.h"

/*
 *========================================================================
 * Useful defines
 *========================================================================
 */

#define STDIN	stdin
#define STDOUT	stdout
#define STDERR	stderr
#define YES	1
#define NO	0
#define PI 3.141592653589793238462643
#define K       1024

/*
 * Can choose between two timers, gettimeofday() (relatively coarse
 * at roughly 2 usec granularity per call) and the tsc cpu clock timer
 * on Intel/AMD chips (good to perhaps 40-90 nsec).
 *
 * Where one has it, the latter is obviously better but both yield the
 * same answers whereever I test
 */

/* #define NANOTIMER() gettimeofday_nanotimer() */
#define NANOTIMER() nanotimer()


 typedef enum {
   NORMAL,
   VERBOSE,
   V_TIMER,
   V_STARTUP,
   V_WORK,
   V_INIT,
   V_SET_ITER,
   V_MEASURE,
   V_NULL,
   N_VERBOSE
 } Verbose;

 /*
  *========================================================================
  * Subroutine Prototypes
  *========================================================================
  */
 unsigned int makeseed();
 void start_timing();
 void stop_timing();
 void show_results(Test *mytest);
 double delta_timing();
 double time_empty(Test *mytest);
 double time_full(Test *mytest);
 void measure_rate();
 void Usage();
 void header();
 unsigned long long gettsc(void);
 unsigned long long fast_gettsc(void);

 /*
  *========================================================================
  * Global Variables:
  *      samples is the number of samples to be taken
  *      iterations is the number of times the core loop is run (inserted 
  *        so one can minimize errors due to the gettimeofday call itself).
  *      random_flag controls the insertion of usleep(1), probably cruft
  *        as it makes little visible difference EXCEPT in the empty
  *        timing loop (where it is essential and not controlled by
  *        random_flag!).
  *      cache_flag is an experimental control.
  *      xtest is an input variable used to pass the d[i] (and hence
  *        division) variable from the command line.
  *      size is the length of the vector being evaluated.
  *      verbose controls the output -- "normal" is verbose=1.
  *      tv_start and tv_stop are used to record timings.
  *
  *      floattest selects a straight bogomflops run
  *      doubletest selects a double precision bogomflops run (bogomdops?)
  *========================================================================
  */
 int usegettimeofday;  /* 0 by default, 1 selects gttod timer */
 int samples,iterations,stride,random_flag,cache_flag,size;
 int quiet,verbose;
 int floattest,doubletest,transtest;
 int testnum;
 struct timeval tv_start,tv_stop;
 int list_flag;
 typedef struct {
   char hostname[128];
   char vendor_id[128];
   char name[128];
   char speed[128];
   char l2cache[128];
   char bogomips[128];
   char memory[128];
 } Host;

 /*
  * Global vectors and constants for tests.
  */
 double xtest,ytest,result;	/* input variable and global scratch */
 int dummy,idiot;		/* To fool compiler into executing empty cases */
 int *myindex;		        /* re-indexing/shuffling vector */
 double *a,*b,*c,*d,*e;		/* To test double floats */
 double ad,bd,cd,dd,ed;		/* double variables */
 unsigned int *ai,aindex,aitmp; /* To do memtest on unsigned int vectors */
 /* double nanotime_start,nanotime_stop,nanotime_delta,nsec_granularity; */
 double time_limit_base,time_limit_empty,time_limit_full;

 /* Averages and errors */
 double avg_time_empty,avg_time2_empty,sigma_time_empty;
 double avg_time_full,avg_time2_full,sigma_time_full;
 double avg_nanotime,avg_nanotime_sigma,nanotime_norm;
 double avg_megarate;

 gsl_rng *myrandom;  /* global gsl random number generator */
 FILE *fp;         /* pointer to /dev/random, for that benchmark or rng seed */

 Test *test;
 Host host;
 /*
#define NUMFIELDS 8
#define FIELDSIZE 64
 char fields[NUMFIELDS][FIELDSIZE];
 */

 Nanotimer nanotimer;

