/*
 *========================================================================
 * $Id: random_pvm_master.c,v 1.1.1.1 2003/12/17 18:44:20 rgb Exp $
 *
 * See copyright in copyright.h and the accompanying file COPYING
 *========================================================================
 */

/*
 *========================================================================
 *  Project template.
 *========================================================================
 */

#include "random_pvm_master.h"


/*
 * main() is just a shell for routines that parse the command line,
 * do all the requested work, and then exit cleanly.  main() is pretty
 * much all there is in random_pvm.c
 */
int main(int argc, char *argv[]) 
{

 /*
  * Parse command line and set global variables
  */
 parsecl(argc,argv);

 /*
  * Note that most of my random_pvms (except the terminally simple/stupid) 
  * have three phases after parsecl():
  *
  * Startup: Allocate memory, initialize all derivative variables from
  * command line values.  
 random_pvm_startup();
  */

 /*
  * Work: Do all the work.  In a complicated random_pvm, project_work would
  * itself be a shell for a lot of other modular routines.
  */
 random_pvm_work();

 /* 
  * Quit:  Done. Clean up (if necessary) and exit.
 random_pvm_quit();
  */

}
