/*
 *========================================================================
 * $Id: parsecl_master.c,v 1.6 2003/12/17 18:43:11 rgb Exp $
 *
 * See copyright in copyright.h and the accompanying file COPYING
 *========================================================================
 */

#include "project_master.h"

/*
 * This routine sets certain globals to their default values and permits
 * those defaults to be overridden on the command line.
 */

void parsecl(int argc, char **argv)
{
 int opt_c,opt_errflg=0;
 extern char *optarg;
 extern int optind, opterr, optopt;

 /* 
  * Initialize global variables with defaults, then override if
  * desired on command line.  Read the getopt man page to see how
  * to set other variables.  Or insert your own parsing code in here --
  * Sometimes I use getopts, sometimes I parse myself, sometimes both.
  */
 verbose = 0;         /* Default is quiet */
 numslaves = 1;       /* Default is at least one slave */
 delay = 1;           /* Default is one second */

 while ((opt_c = getopt(argc,argv,"d:hn:v")) != EOF){
   switch (opt_c){
     case 'd':
       delay = strtol(optarg,(char **) NULL,10);
       break;
     case 'h':
       Usage();
       exit(0);
       break;
     case 'n':
       numslaves = strtol(optarg,(char **) NULL,10);
       break;
     case 'v':
       verbose = 1;
       break;
     case '?':
       opt_errflg++;
   }
 }
 /*
  * Check for too many nodes
  */
 if(numslaves > K) Usage();

 /*
  * If there are no more arguments, we are done.
  */
 if(argc-optind == 0){
   return;
 }

 /*
  * Anything else left is an erroneous call and should cause the Usage
  * message to be printed.  memtest -h or --help will therefore "work".
  */

 Usage();

}

void Usage()
{

 fprintf(stdout, "\n");
 fprintf(stdout, "Usage: \n");
 fprintf(stdout, "  project_master -n N -d D [-h] [-v]\n");
 fprintf(stdout, "\n");
 fprintf(stdout, "   -n N (where N is the number of slaves to run)\n");
 fprintf(stdout, "   -d D (where D is a delay, in seconds)\n");
 fprintf(stdout, "   -v selects \"verbose\" operation for debugging, very noisy.\n");
 fprintf(stdout, "   -h prints usage statement (this message) and exits.\n");
 fprintf(stdout, "\n");
 exit(0);

}
