/*
 *========================================================================
 * $Id: project.c,v 1.1.1.1 2000/12/31 06:00:45 rgb Exp $
 *
 * See copyright in copyright.h and the accompanying file COPYING
 *========================================================================
 */

/*
 *========================================================================
 *  Project template.
 *========================================================================
 */

#include "project.h"


/*
 * main() is just a shell for routines that parse the command line,
 * do all the requested work, and then exit cleanly.  main() is pretty
 * much all there is in project.c
 */
int main(int argc, char *argv[]) 
{

 /*
  * Parse command line and set global variables
  */
 parsecl(argc,argv);

 /*
  * Note that most of my projects (except the terminally simple/stupid) 
  * have three phases after parsecl():
  *
  * Startup: Allocate memory, initialize all derivative variables from
  * command line values.  
 project_startup();
  */

 /*
  * Work: Do all the work.  In a complicated project, project_work would
  * itself be a shell for a lot of other modular routines.
  */
 project_work();

 /* 
  * Quit:  Done. Clean up (if necessary) and exit.
 project_quit();
  */

}
