/*
 *========================================================================
 * $Id: dieharder.c 127 2004-11-20 18:17:55Z rgb $
 *
 * See copyright in copyright.h and the accompanying file COPYING
 *========================================================================
 */

/*
 *========================================================================
 *  run_rgb_bitdist()
 *========================================================================
 */

#include "dieharder.h"

void run_sts_serial()
{

 /*
  * Declare the results struct.
  */
 Test **sts_serial_test;
 int i;

 /*
  * Set any GLOBAL data used by the test.  We will gradually
  * adjust the testing struct and sequence as needed to permit
  * a whole set of tests to be run with a single call, and be
  * stored correctly in a vector of pvalues EACH WITH THEIR
  * OWN DESCRIPTION LINE that can be set in the testing routine.
  *
  * So we actually will not use or need any global ntuple variable
  * here -- we only run the actual sts_serial test ONCE.
  */

 /*
  * First we create the test (to set some values displayed in test header
  * correctly).
  */
 sts_serial_test = create_test(&sts_serial_dtest,tsamples,psamples,&sts_serial);

 /*
  * This particular test we need to pre-initialize the pvlabel for
  * each test, in order.
  */
 snprintf(sts_serial_test[0]->pvlabel,LINE,"# Normal p-value for STS Serial test for n=1 bit (STS Monobit)\n");
 snprintf(sts_serial_test[1]->pvlabel,LINE,"# p-value 1 for STS Serial test for n=2 bits\n");
 for(i=0;i<14;i++){
    snprintf(sts_serial_test[2*i+2]->pvlabel,LINE,"# p-value 1 for STS Serial test for n=%u bits\n",i+3);
    snprintf(sts_serial_test[2*i+3]->pvlabel,LINE,"# p-value 2 for STS Serial test for n=%u bits\n",i+3);
 }
   

 /*
  * Show the standard test header for this test.
  */
 show_test_header(&sts_serial_dtest,sts_serial_test);

 /*
  * Append the following SPECIAL line
 printf("# Testing all 1-16 bit ntuples in 32-bit random words\n",sts_serial_ntuple);
 fflush(stdout);
  */

 /*
  * Set any GLOBAL data used by the test.  Then call the test itself
  * This fills in the results in the Test struct.
  */
 std_test(&sts_serial_dtest,sts_serial_test);

 /*
  * This almost certainly belongs in the show_test_results section,
  * possibly with additional conditionals rejecting test results involving
  * rewinds, period.
  */
 if(strncmp("file_input",gsl_rng_name(rng),10) == 0){
   printf("# %u rands were used in this test\n",file_input_get_rtot(rng));
   printf("# The file %s was rewound %u times\n",gsl_rng_name(rng),file_input_get_rewind_cnt(rng));
   fflush(stdout);
 }

 /*
  * Show standard test results, for all statistics generated by a single run.
  */
 show_test_results(&sts_serial_dtest,sts_serial_test);

 /*
  * Free any GLOBAL data used by the test.
  */
 destroy_test(&sts_serial_dtest,sts_serial_test);


}
