/*
 * $Id: timenano.c,v 1.4 2005/03/10 15:53:14 rgb Exp $
 * See copyright in copyright.h and the accompanying file COPYING
 */

#include "benchmaster.h"

 /*
  *==================================================================
  * This is the "timenano test".  It basically measures the time
  * required to call a generic empty (timenano) function and how
  * accurately the timing harness is at determining a NET time for
  * executing its (empty) contents.
  *==================================================================
  */

void timenano_init(Test *mytest){

 mytest->vector = 0;
 mytest->ranok = 0;
 mytest->alloc = timenano_alloc;
 mytest->free = timenano_free;
 mytest->test = timenano_test;
 mytest->results = timenano_results;
 snprintf(mytest->name,K,"timenano test");
 snprintf(mytest->about,K,"times nanotimer.timer() call itself");

 if(verbose == VERBOSE || verbose == V_INIT){
   printf("# Init for test %s\n",mytest->name);
 }

}

void timenano_alloc()
{
}

void timenano_free()
{
}

int timenano_test(int full_flag)
{

 if(full_flag == 1){
   nanotimer.timer();
   return(full_flag);
 } else {
   return(full_flag);
 }
}

void timenano_results(Test *mytest)
{

 /*
  * Any conversion or renormalization should happen here, but
  * the actual output line should be the same for all tests.
  */
 mytest->avg_time = fabs(mytest->avg_time_full - mytest->avg_time_empty);
 mytest->sigma = mytest->sigma_time_full + mytest->sigma_time_empty;
 mytest->min_time = fabs(mytest->min_time - mytest->avg_time_empty);
 mytest->max_time = fabs(mytest->max_time - mytest->avg_time_empty);
 mytest->avg_megarate = 1000.0/mytest->avg_time;
 mytest->max_megarate = 1000.0/mytest->min_time;
 mytest->min_megarate = 1000.0/mytest->max_time;

 show_results(mytest);

}

