/*
* $Id: time_full.c,v 1.2 2004/12/15 22:19:15 rgb Exp $
*
* See copyright in copyright.h and the accompanying file COPYING
*
*/

#include "benchmaster.h"

/*
 *==================================================================
 * Time the "full" branch in each test.  The full loop should
 * DIFFER from the empty branch by precisely the code to be timed.
 *==================================================================
 */

double time_full(Test *mytest)
{

 int i;
 /*
  * Time the full branch.  The usleep may or may not help stabilize
  * the state of the machine before entering the timing loop.  We really
  * want to enter it right after a timing interrupt so we have 1/100 of
  * a second without an "expected" interrupt, but I haven't found it to
  * make much difference.
  */
 usleep(1000);
 nanotimer.start = nanotimer.timer();
 for(i=0;i<mytest->full_iter;i++){
   mytest->test(1);
 }
 nanotimer.stop = nanotimer.timer();
 nanotimer.delta = nanotimer.stop - nanotimer.start;
 return(nanotimer.delta);

}
