/*
* $Id: measure_rate.c,v 1.48 2005/04/27 21:25:01 rgb Exp $
*
* See copyright in copyright.h and the accompanying file COPYING
*
*/

#include "benchmaster.h"

/*
 *==================================================================
 * This is the primary timing shell.  set_iter(&test) has already
 * run preliminary loops of the test to be run to determine how
 * many times it has to be repeated to get decent timer precision
 * on the result (automagically).  Now we just run the loops both
 * empty and full.
 *==================================================================
 */

void measure_rate(Test *mytest)
{

 double total_time,total_time2,max_time,min_time;
 int i,j,k,rejections;
 struct timespec ts;
 struct timeval tv;
 double test_nanotime;

 if(verbose == V_MEASURE || verbose == VERBOSE) {
   printf("# measure_rate: Entering measure_rate() for %s.  %d to focus.\n",mytest->name,V_MEASURE);
 }

 /*
  * Always begin by allocating any space required for running THIS
  * test.
  */
 if(verbose == V_MEASURE || verbose == VERBOSE) {
   printf("# measure_rate: Entering mytest->alloc()\n");
 }
 mytest->alloc();
 

 /*
  * Measure the empty loop time.
  */
 total_time = 0.0;
 total_time2 = 0.0;
 rejections = 0;
 for(k=0;k<samples;k++){


   if(verbose == V_MEASURE || verbose == VERBOSE) {
     printf("Timing empty test %d time\n",k);
   }
   test_nanotime = time_empty(mytest);

   /*
    * test_nanotime is now the time, in nanoseconds, of a single empty
    * test loop (including subroutine call and conditional overhead).  We
    * reject samples that are bigger than 2*time_limit_empty, as they are
    * almost certainly caused by spurious timer (or other) interrupts
    * occuring in the middle of the sampling.  Some places we might want
    * to average them in; here we don't.
    */
   if(test_nanotime > 1.05*time_limit_empty && rejections < samples){

     /*
      * Basically, "repeat the measurement".  Probably need a check
      * for an infinite loop here, in case set_iter set an irrational
      * upper time limit.
      */
     if(verbose == VERBOSE || verbose == V_MEASURE){
       test_nanotime /= mytest->empty_iter;
       printf("# measure_rate(): rejecting test time of = %e (nsec)\n",
          test_nanotime);
     }
     rejections++;
     k--;

   } else {

     test_nanotime /= mytest->empty_iter;
     if(verbose == V_MEASURE || verbose == VERBOSE) {
       printf("# measure_rate(): mytest->empty_iter = %d test time = %e (nsec)\n",mytest->empty_iter,test_nanotime);
     }
     total_time += test_nanotime;
     total_time2 += test_nanotime*test_nanotime;

   }

 }
 mytest->avg_time_empty = total_time/samples;
 mytest->avg_time2_empty = total_time2/samples;
 if(samples>1){
   mytest->sigma_time_empty = sqrt(( mytest->avg_time2_empty -
      mytest->avg_time_empty*mytest->avg_time_empty)/(samples-1.0));
 } else {
   mytest->sigma_time_empty = 1.0e300;
 }

 if(verbose == V_MEASURE || verbose == VERBOSE) {
   printf("#\n# measure_rate: test %s mean time empty = %e +/0 %e\n#\n",
      mytest->name,mytest->avg_time_empty,mytest->sigma_time_empty);
 }


 /*
  * Measure the full loop time.  Always reject the 0'th sample, as the
  * first sample time is likely to be anomalously large as L1 gets filled.
  */
 total_time = 0.0;
 total_time2 = 0.0;
 max_time = 0.0;
 min_time = INFINITY;
 rejections = 0;
 best_time = INFINITY;
 for(k=0;k<=samples;k++){
   /*
    * We need an independent shuffle for each sample, right?
    * But only in shuffle mode.
    */
   if(random_flag && mytest->ranok == 1){
     gsl_ran_shuffle(myrandom, ai, size, sizeof (unsigned int));
     if(verbose == V_MEASURE || verbose == VERBOSE){
       printf("#==================================================================\n");
       for(i=0;i<size;i++) printf("# Shuffled: ai[%d] = %u\n",i,ai[i]);
       printf("#==================================================================\n");
     }
   }
   test_nanotime = time_full(mytest);

/*   
   usleep(1000);
   nanotimer.start = nanotimer.timer();
   for(j=1;j<=mytest->full_iter;j++){
      mytest->test(1);
   }
   nanotimer.stop = nanotimer.timer();
   nanotimer.delta = nanotimer.stop - nanotimer.start;
*/


   /*
    * test_nanotime is now the time, in nanoseconds, of a single
    * full test loop (including subroutine call and conditional overhead).
    */
   if(test_nanotime > 1.05*time_limit_full && rejections < samples || k == 0){
     /*
      * Basically, "repeat the measurement".  Probably need a check
      * for an infinite loop here, in case set_iter set an irrational
      * upper time limit.
      */
     if(verbose == VERBOSE || verbose == V_MEASURE){
       printf("# measure_rate(): time_limit_full = %e full loop test time = %e (nsec)\n",
          time_limit_full,test_nanotime);
       test_nanotime /= mytest->full_iter;
       if(k == 0){
         printf("# measure_rate(): rejecting initial test time to load L1 = %e (nsec)\n",
            test_nanotime);
       } else {
         printf("# measure_rate(): rejecting test time (failed tolerance) = %e (nsec)\n",
            test_nanotime);
       }
     }
     rejections++;
     if(k > 0) k--;
   } else {
     test_nanotime /= mytest->full_iter;
     if(test_nanotime < min_time) {
       /* printf("previous min = %e  new min = %e\n",min_time,test_nanotime); */
       min_time = test_nanotime;
     }
     if(test_nanotime > max_time) {
       /* printf("previous max = %e  new max = %e\n",max_time,test_nanotime); */
       max_time = test_nanotime;
     }
     if(verbose == V_MEASURE || verbose == VERBOSE) {
       printf("# measure_rate: mytest->full_iter = %d test time = %e\n",mytest->full_iter,test_nanotime);
     }
     total_time += test_nanotime;
     total_time2 += test_nanotime*test_nanotime;
     if(best_flag == YES){
       if(test_nanotime < best_time) best_time = test_nanotime;
       if(verbose == V_MEASURE || verbose == VERBOSE) {
         printf("# measure_rate: best_time = %f\n",best_time);
       }
     }
   }
 }
 mytest->avg_time_full = total_time/samples;
 mytest->avg_time2_full = total_time2/samples;
 mytest->max_time = max_time;
 mytest->min_time = min_time;
 printf("avg full = %e min = %e  max = %e\n",mytest->avg_time_full,min_time,max_time);
 if(samples>1){
   mytest->sigma_time_full = sqrt(( mytest->avg_time2_full -
      mytest->avg_time_full*mytest->avg_time_full)/(samples-1.0));
 } else {
   mytest->sigma_time_full = 1.0e300;
 }

 if(verbose == V_MEASURE || verbose == VERBOSE) {
   printf("#\n# measure_rate: test %s mean time full = %e +/0 %e\n#\n",
      mytest->name,mytest->avg_time_full,mytest->sigma_time_full);
 }

 /*
  * Always end by freeing any space allocated above for THIS test.
  */
 mytest->free();
 
}
