# The following should match PROGRAM, VERSION and RELEASE in the
# Makefile accompanying this program (and the .tgz defined in Source
# below.


Name: wulfware
Version: 2.5.0
Summary: A LAN/cluster/beowulf monitoring suite
Release: 1
Group: Applications/System
License: Open Source (GPL v2b)
Source: %{name}-%{version}.tgz
Buildroot: /var/tmp/%{name}-%{version}-%{release}-root

%description 

########################################################################
# LIBRARY: This is the basic wulfware library
########################################################################
%package -n libwulf
Summary: The core library for xmlsysd clients
Group: Applications/System
Requires: libxml2
%description -n libwulf

libwulf is the core common library required by wulfstat and wulflogger,
two xmlsysd clients that poll and display various statistics from a
cluster in a user-controllable loop.  libwulf contains routines that
open and parse a wulfhosts (cluster/lan descriptor) file, establish
xmlsysd connections in a threaded subtask to all hosts in the wulfhosts
file, and in parallel with this initialize and update selected
statistics.  libwulf functions form an API adequate to support many
kinds of toplevel log and gui applications reasonably efficiently.

########################################################################
# P0: This is the xmlsysd daemon for the nodes/LAN clients
########################################################################
%package -n xmlsysd
Summary: A system information daemon that returns and xml wrap of proc data
Group: System Environment/Daemons
Requires: xinetd

%description -n xmlsysd

xmlsysd is a system information daemon that recognizes a simple command
language that causes it to execute certain systems calls and parse
various system information files in /proc, convert the information it
thus obtains into an xml encapsulation, and send the xml data out via a
socket connection.  It supports both a forking daemon mode that can be
run from userspace and an xinetd mode that can be run out of xinetd.  In
most situations the latter is more securable and controllable and this
rpm installs it in this mode.  xmlsysd is the basic (required)
information daemon used by various clients in the wulfware project.

########################################################################
# P1: This is the wulfstat client
########################################################################
%package -n wulfstat
Summary: A LAN/cluster/beowulf monitoring tool
Group: Development/Tools
Requires: libwulf >= 2
%description -n wulfstat

wulfstat is a simple yet powerful tty (ncurses) based cluster monitoring
tool.  It requires xmlsysd (running on each system to be monitored) to
efficiently provide it with system and proc-derived information that is
processed and provided to the user in one of several user-selectable
display formats.  With it a user can monitor things across en entire
beowulf, cluster, or workstation LAN systems descriptors such as load
average, memory consumption, swap, page, and interrupt activity and
network loads or can even retrieve and display such mundane information
is CPU make and base clock, system time, uptime or other potentially
useful but slowly varying system descriptors.  The information presented
is updated regularly after a user-selectable delay.  The tool allows
displays to be selected or changed while the application is running, and
more hosts or nodes can be displayed than will easily fit on a single
e.g. xterm by paging through them with key-based commands.

########################################################################
# P2: This is the wulflogger client
########################################################################
%package -n wulflogger
Summary: A LAN/cluster/beowulf monitoring tool
Group: Development/Tools
Requires: libwulf >= 2
%description -n wulflogger
wulflogger is a command line tool for generating a running display of
selected cluster statistics, e.g. load averages.  It uses the same
wulfhosts file as wulfstat (and generates largely the same displays) but
writes them to stdout as columnated lines from where they can easily be
piped into files, parsed and fed to graphing/display programs such as
rrdtool or saved as archival records.  It requires xmlsysd on the hosts
being monitored and the libwulf library to run.

########################################################################
# P3: This is the wulf2html web page builder client
########################################################################
%package -n wulf2html
Summary: A LAN/cluster/beowulf monitoring webpage builder
Group: Development/Tools
Requires: libwulf >= 2
%description -n wulf2html
Wulfweb is a kit consisting of several perl scripts and other tools
based on wulflogger that take wulflogger output for a given cluster and
present it as an html table of results.  Ordinarily this table will be
included in a web page with a meta tag (template included) that causes
it to be automatically refreshed every minute or so.  This basically
permits a wulfstat-like display to be presented to any web browser.
Wulfweb requires that both xmlsysd on the clients being monitored and
wulflogger be installed.

########################################################################
# The main section common to all builds.
########################################################################
%prep
%setup -q -n %{name}-%{version}

%build
make clean
make

# Note that multipackage sources with libraries are happier with
# their own local buildroot to facilitate development without a
# full install.
%install
make BUILDROOT=%{buildroot} PREFIX=%{buildroot}/usr install

%clean
rm -rf $RPM_BUILD_ROOT
rm -rf %{builddir}

########################################################################
# Files in libwulf
########################################################################
%files -n libwulf

%defattr(-,root,root)

# The libwulf library
# /usr/lib/libwulf.a
/usr/lib/libwulf.so
/usr/lib/libwulf.so.%{version}

# The libwulf include files are under here
%attr(644,root,root) /usr/include/wulfware

# The libwulf man page
%attr(644,root,root) /usr/share/man/man3/libwulf.3.gz

# The wulfware docs go in with the library, since the library
# is likely to be installed "everywhere".
%doc Copyright README COPYING NOTES

########################################################################
# P0: Files for xmlsysd
########################################################################
%files -n xmlsysd
%defattr(-,root,root)

# The xmlsysd binary
%attr(755,root,root) /usr/sbin/xmlsysd

# The xmlsysd man page
%attr(644,root,root) /usr/share/man/man8/xmlsysd.8.gz

# xinetd config
%config(noreplace) %{_sysconfdir}/xinetd.d/xmlsysd

########################################################################
# P1: Files for wulfstat
########################################################################

%files -n wulfstat
%defattr(-,root,root)

# The wulfstat binary
%attr(755,root,root) /usr/bin/wulfstat

# The wulfstat man page
%attr(644,root,root) /usr/share/man/man1/wulfstat.1.gz

########################################################################
# P2: Files for wulflogger
########################################################################

%files -n wulflogger
%defattr(-,root,root)

# The wulflogger binary
%attr(755,root,root) /usr/bin/wulflogger

# The wulflogger man page
%attr(644,root,root) /usr/share/man/man1/wulflogger.1.gz

########################################################################
# P3: Files for wulf2html
########################################################################

%files -n wulf2html
%defattr(-,root,root)

# The wulf2html script
%attr(755,root,root) /usr/bin/wulf2html

# The actual loop script for the different displays
%attr(755,root,root) /etc/init.d/wulf2html

# The actual loop script for the different displays
%attr(755,root,root) /etc/wulfware/wulf2html.sh

# A prototype cluster header file for wulf2html, used in
# the loop script.
%attr(644,root,root) /etc/wulfware/cluster_header.html

# Finally, we need a prototype wulfhosts file
%attr(644,root,root) /etc/wulfware/wulfhosts

# The wulf2html man page
%attr(644,root,root) /usr/share/man/man1/wulf2html.1.gz

########################################################################
# %post and %postun for libwulf
########################################################################
%post -n libwulf

cd /usr/lib
ln -sf libwulf.so.%{version} libwulf.so 
ldconfig -n .

%postun -n libwulf

rm -f /usr/lib/libwulf.so
ldconfig

########################################################################
# %post and %postun for xmlsysd
########################################################################
%post -n xmlsysd
chkconfig xmlsysd on
service xinetd condrestart

%postun -n xmlsysd
service xinetd condrestart

########################################################################
# %post for wulf2html
########################################################################
%post -n wulf2html
chkconfig --add wulf2html

%preun -n wulf2html
chkconfig --del wulf2html

%changelog
* Tue Nov  11 2004 Robert G. Brown <rgb@duke.edu>
- Releasing v 0.4.0 beta -- first public release.
