/*
 *========================================================================
 * $Id: libwulf.h 90 2004-09-30 17:38:02Z rgb $
 *
 * See copyright in libwulf_copyright.h and the accompanying file COPYING
 *========================================================================
 */

#include <wulfware/libwulf_copyright.h>

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <strings.h>
#include <string.h>
#include <signal.h>
#include <ctype.h>
#include <pthread.h>
#include <time.h>
#include <math.h>
#include <errno.h>
#include <sys/file.h>
#include <sys/dir.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/select.h>
#include <sys/un.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>

/*
 *========================================================================
 * Useful defines
 *========================================================================
 */
#define STDIN	stdin
#define STDOUT	stdout
#define STDERR	stderr
#define OUTFP   stderr
#define YES	1
#define NO	0
#define PI 3.141592653589793238462643
#define K 1024
#define K4 4096
#define K64 65536
#define UDELAY 0


/*
 * This is all structs and enums needed to extract and store the values
 * on a per-host basis for further processing and display.
 */
#include <wulfware/libwulf_values.h>

/* 
 * This ensures that wulfstat can execute all the commands recognized
 * by xmlsysd, no more and no less.  With a fair bit of work, of course...;-)
 */
#include <wulfware/libwulf_commands.h>

/*
 * These are structs used to xml-parse wulfhosts
 */
#include <wulfware/libwulf_wulfhosts.h>

/* the main gnome include */
/* #include <gnome.h> */

/*
 * The primary host structs.  Must be included after wulfhosts.h
 * xml stuff.
 */
#include <wulfware/libwulf_wulfhost.h>

/*
 * Subroutine Prototypes
 */
#include <wulfware/libwulf_prototypes.h>

/*
 *========================================================================
 * Debug enum -- one per separate component, no particular order
 *========================================================================
 */
 typedef enum {
   D_QUIET,
   D_ALL,
   D_MAIN,
   D_UTIL,
   D_PARSECL,
   D_STARTUP,
   D_WORK,
   D_PARSE,
   D_CONNECT,
   D_INIT_HOST,
   D_CONNECT_HOSTS,
   D_READHOST,
   D_SENDCMD,
   D_SELECT_OPTION,
   D_EXTRACT_VALUES,
   D_INIT_VALUES,
   D_UPDATE_VALUES,
   D_VALUES,
   D_DISPLAY_VALUES,
   D_DISPLAY_DEBUG,
   D_SCREEN,
   D_XMLSYSD,
   D_QUIT,
   N_DEBUG
 } Debug;

 /*
  *========================================================================
  * Global Variables and relevant #defines
  *
  * Set the default values and override from the command line in parsecl().
  *========================================================================
  */

 /* 
  * verbose is a debug switch.  One can switch on the debugging
  * of many components of the program with different values.  However
  * one has to read the source to know what turns on what.
  */
 extern int verbose;
 extern int udelay;

 /*
  * 64K i/o buffers for receiving/parsing the xmlsysd returns.  Global is
  * faster, but we absolutely must NOT use the same buffers on the
  * connection/initialization thread and the update thread, as eventually
  * they are bound to collide with unpredictable results.
  */
 char init_buf[K64];
 char update_buf[K64];
 /*
  * For parsing attributes etc.
  */
 char tmp_buf[K];
