/*
 * $Id: timesleep.c,v 1.1 2004/06/15 05:12:36 rgb Exp $
 * See copyright in copyright.h and the accompanying file COPYING
 */

#include "cpu_rate.h"

 /*
  *==================================================================
  * This is the "timesleep test".  It basically measures the time
  * required to call a generic empty (timesleep) function and how
  * accurately the timing harness is at determining a NET time for
  * executing its (empty) contents.
  *==================================================================
  */

void timesleep_init(Test *mytest){

 mytest->alloc = timesleep_alloc;
 mytest->free = timesleep_free;
 mytest->test = timesleep_test;
 mytest->results = timesleep_results;
 snprintf(mytest->name,K,"timesleep test");
 snprintf(mytest->about,K,"result = xtest*ytest");

 if(verbose == VERBOSE || verbose == V_INIT){
   printf("# Init for test %s\n",mytest->name);
 }

}

void timesleep_alloc()
{
}

void timesleep_free()
{
}

int timesleep_test(int full_flag)
{

 struct timespec ts;
 ts.tv_sec = 0;
 ts.tv_nsec = 1;

 if(full_flag == 1){
   nanosleep(ts,NULL);
   return(full_flag);
 } else {
   return(full_flag);
 }
}

void timesleep_results(Test *mytest)
{

 /*
  * Any conversion or renormalization should happen here, but
  * the actual output line should be the same for all tests.
  */
 mytest->avg_time = fabs(mytest->avg_time_full - mytest->avg_time_empty);
 mytest->sigma = mytest->sigma_time_full + mytest->sigma_time_empty;
 mytest->avg_megarate = 1000.0/mytest->avg_time;

 show_results(mytest);

}

