/*
* $Id: time_empty.c,v 1.1 2004/06/15 05:12:36 rgb Exp $
*
* See copyright in copyright.h and the accompanying file COPYING
*
*/

#include "cpu_rate.h"

/*
 *==================================================================
 * Time the "empty" branch in each test.  This need not be empty;
 * times are differenced to produce the final result.
 *==================================================================
 */

double time_empty(Test *mytest)
{

 int i;
 /*
  * Time the empty branch.  The usleep may or may not help stabilize
  * the state of the machine before entering the timing loop.  We really
  * want to enter it right after a timing interrupt so we have 1/100 of
  * a second without an "expected" interrupt, but I haven't found it to
  * make much difference.
  */
 usleep(1000);
 nanotimer.start = nanotimer.timer();
 for(i=0;i<mytest->empty_iter;i++){
   mytest->test(0);
 }
 nanotimer.stop = nanotimer.timer();
 nanotimer.delta = nanotimer.stop - nanotimer.start;
 return(nanotimer.delta);

}
