/*
 * $Id: stream_add.c,v 1.8 2004/06/14 23:38:49 rgb Exp $
 * See copyright in copyright.h and the accompanying file COPYING
 */

#include "cpu_rate.h"

 /*
  *==================================================================
  * This is the "add" test from the stream suite.  It is not
  * directly comparable to stream results for a variety of reasons.
  * For one, it uses malloc to allocate all vectors and consequently
  * adds one more degree of indirection to address resolution.  It
  * returns results that are SLIGHTLY LOWER/SLOWER than regular
  * stream (but which may be more realistic for general purpose code).
  *
  * It also uses a different timing harness, one that is both
  * more accurate (uses a superior timer) and which repeats the
  * computation many times to obtain both a mean and a standard
  * deviation on the test results.
  *==================================================================
  */

void stream_add_init(Test *mytest){

 int i;

 mytest->alloc = stream_add_alloc;
 mytest->free = stream_add_free;
 mytest->test = stream_add_test;
 mytest->results = stream_add_results;
 snprintf(mytest->name,K,"stream add");
 snprintf(mytest->about,K,"d[i] = a[i] + b[i] (%d byte double vector)",sizeof(double));

 if(verbose == VERBOSE || verbose == V_INIT){
   printf("# Init for test %s\n",mytest->name);
 }

}

void stream_add_alloc()
{

 int i;

 /*
  * Allocate vector(s) to be tested with and initialize it and all
  * associated test-specific variables.
  */
 d = (double *) malloc((size_t) (size*sizeof(double)));
 a = (double *) malloc((size_t) (size*sizeof(double)));
 b = (double *) malloc((size_t) (size*sizeof(double)));
 /* xtest is set from the command line, default PI */
 /* Initialize the vectors */
 for(i=0;i<size;i+=stride){
   a[i] = xtest;
   b[i] = xtest;
 }

}

void stream_add_free()
{

 int i;

 /*
  * Free all the memory we just allocated, to be neat and clean and
  * all that.
  */
 free(a);
 free(b);
 free(d);

}

int stream_add_test(int full_flag)
{

 int i;
 
 if(full_flag){
   for(i=0;i<size;i+=stride){
     d[i] = a[i] + b[i];
   }
 } else {
   return(full_flag);
 }
}

void stream_add_results(Test *mytest)
{

 double nanotime_norm;

 /*
  * This is the number of add operations in the core loop
  */
 nanotime_norm = (double)size/stride;

 mytest->avg_time = fabs(mytest->avg_time_full - mytest->avg_time_empty)/nanotime_norm;
 mytest->sigma = (mytest->sigma_time_full + mytest->sigma_time_empty)/nanotime_norm;
 mytest->avg_megarate = 1000.0/mytest->avg_time;

 show_results(mytest);

}

