/*
* $Id: savage.c,v 1.2 2004/06/14 21:26:27 rgb Exp $
*
* See copyright in copyright.h and the accompanying file COPYING
*
*/

#include "cpu_rate.h"

 /*
  *==================================================================
  * This is the "savage" transcendental benchmark.  It ignores size
  * and stride -- it just microtimes a particular collection of
  * transcendental function calls to give one some idea of how
  * efficiently certain libm functions are implemented and whether or
  * not there is hardware support for same.
  *==================================================================
  */

void savage_init(Test *mytest){

 int i;

 mytest->alloc = savage_alloc;
 mytest->free = savage_free;
 mytest->test = savage_test;
 mytest->results = savage_results;
 snprintf(mytest->name,K,"savage");
 snprintf(mytest->about,K,"xtest = tan(atan(exp(log(sqrt(xtest*xtest)))))");

 if(verbose == VERBOSE || verbose == V_INIT){
   printf("# Init for test %s\n",mytest->name);
 }

}

void savage_alloc()
{
}

void savage_free()
{
}

int savage_test(int full_flag)
{
 int i;
 double savage;

 if(full_flag){
   /* Full */
   savage = tan(atan(exp(log(sqrt(xtest*xtest)))));
   savage = tan(atan(exp(log(sqrt(xtest*xtest)))));
   return(full_flag);
 } else {
   /* Empty */
   savage = tan(atan(exp(log(sqrt(xtest*xtest)))));
   return(full_flag);
 }
}

void savage_results(Test *mytest)
{

 double nanotime_norm;

 /*
  * This is basically the number of core loop executions of the savage
  * line.  Note that size/stride are irrelevant.
  */
 mytest->avg_time = fabs(mytest->avg_time_full - mytest->avg_time_empty);
 mytest->sigma = (mytest->sigma_time_full + mytest->sigma_time_empty);
 mytest->avg_megarate = 1000.0/mytest->avg_time;

 show_results(mytest);

}

