/*
 * $Id: parsecl.c,v 1.17 2004/06/11 14:32:48 rgb Exp $
 *
 * See copyright in copyright.h and the accompanying file COPYING
 *
 */

#include "cpu_rate.h"

void parsecl(int argc, char **argv)
{
 int imax,i,c,errflg=0;
 extern char *optarg;
 extern int optind, opterr, optopt;

 samples = 100;		/* Should NOT be a "lot", 10-100 is plenty */
 iterations = -1;	/* This should be just enough to do empty accurately */
 list_flag = 0;         /* Do not list all tests unless asked nicely */
 size = 1000;		/* Small enough to easily fit into any cache */
 stride = 1;		/* Vector stride used */
 random_flag = 0;	/* Default is to NOT shuffle/randomize vector ops */
 verbose = 0;		/* Default is to be a bit noisy (debugging control). */
 quiet = 0;		/* Default is NOT to be quiet (output control). */
 xtest = PI;		/* Default is PI to many digits */
 testnum = -1;		/* Default is no test at all */
 usegettimeofday = 0;   /* Default is to NOT use gettimeofday timer */

 while ((c = getopt(argc,argv,"cd:fghi:ln:qrs:t:v:x:")) != EOF){
   switch (c){
     case 'd':
       stride = strtol(optarg,(char **) NULL,10);
       break;
     case 'g':
       usegettimeofday = 1;
       break;
     case 'h':
       Usage();
       exit(0);
       break;
     case 'i':
       iterations = strtol(optarg,(char **) NULL,10);
       break;
     case 'l':
       list_flag = 1;   /* We actually do this later */
       break;
     case 'n':
       samples = strtol(optarg,(char **) NULL,10);
       break;
     case 'q':
       quiet = 1;
       break;
     case 'r':
       random_flag = 1;
       break;
     case 's':
       size = strtol(optarg,(char **) NULL,10);
       break;
     case 't':
       testnum = strtol(optarg,(char **) NULL,10);
       break;
     case 'v':
       verbose = strtol(optarg,(char **) NULL,10);
       printf("Verbose is now %d\n",verbose);
       break;
     case 'x':
       xtest = strtod(optarg,(char **) NULL);
       break;
     case '?':
       errflg++;
   }
 }

 /*
  * If there are no more arguments, we are done.
  */
 if(argc-optind == 0){
   return;
 }

 /*
  * Anything else left is an erroneous call and should cause the Usage
  * message to be printed.  memtest -h or --help will therefore "work".
  */

 Usage();

}

static char *Usagestring[] = {
" ",
"Usage:",
"   cpu_rate -t testnumber [-q] [-h] [-i iterations] [-n num_samples]",
"            [-s size] [-d stride] [-x xtest] [-r] [-v verbosity]",
" ", 
"   -t testnumber selects benchmark to be run:",
"      0 is empty loop",
"      1 is bogomflops d[i] = (d[i] + ad)*(bd - d[i])/d[i]",
"      2 is bogomtrids (average +-*) d[i] = (ad + bd - cd)*d[i]",
"      3 is stream copy d[i] = a[i]",
"      4 is stream scale d[i] = xtest*d[i]",
"      5 is stream add d[i] = a[i] + b[i]",
"      6 is stream triad d[i] = a[i] + xtest*b[i]",
"      7 is memtest sequential ai[ai[i]] swap",
"      8 is memtest backwards sequential ai[ai[i]] swap",
"      80 is memtest backwards sequential \"simple\" ai[ai[i]] swap",
"      9 is memtest random ai[ai[i]] swap",
"     10 is savage: xtest = tan(atan(exp(log(sqrt(xtest*xtest)))))",
"     11 is /dev/random unsigned int rate ",
"     12 is empty() (empty subroutine call)",
"   Any other values test the empty (timing) loop",
" ",
"   -i controls the number of iterations inside the sampling loop.",
"      If omitted, iterations are automatically scaled (best).",
"   -n controls the number of samples (default 100)",
"   -x xtest allows one to set the x used in the vector (and hence to divide).",
"      Powers of 2 are anomalously optimized on some architectures.",
"   -s controls the size of the double vector.  This allows one to ",
"      observe the effects of L1 and L2 cache size on the result.",
"   -d controls the delta/stride used to step through vector sizes. ",
"   -r causes a vector test to use shuffled order, if enabled.\n",
"   -q selects \"quiet\" operation: results only are printed on a single line",
"   -v verbosity controls selectable debugging output.",
"   -h prints usage statement (this message) and exits.",
"   NOTE WELL:  The \"Mega-rates\" returned by this tool are BOGUS",
"   and may not be even approximately correct.  Be Warned!",
"",0};


void Usage()
{

 int i=0;
 while(Usagestring[i]){
   fprintf(stderr,"%s\n",Usagestring[i]);
   i++;
 }

}

