/*
 *========================================================================
 * $Id: parse.c,v 1.1 2004/06/11 20:31:29 rgb Exp $
 *
 * See copyright in copyright.h and the accompanying file COPYING
 *========================================================================
 */

#include "cpu_rate.h"

/*
 * parse() is a reusable routine to break up a string into char[32]
 * fields.  Anything past 32 characters is truncated.
 */

int parse(char *inbuffer,char **outfields,int maxfields,int maxfieldlength)
{

 char delim[7],*nextval;
 int i = 0;

 if((verbose == VERBOSE) || (verbose == V_INIT)){
   printf("V_INIT: Starting parse().  Use -v %d to focus.\n",V_INIT);
 }



/* 
 * Permit blank, tab, or comma separators anywhere we need to parse
 * a line.
 */
 delim[0] = ' ';                /* blanks */
 delim[1] = (char) 9;           /* tab */
 delim[2] = ',';                /* comma */
 delim[3] = (char) 10;		/* LF */
 delim[4] = (char) 13;		/* CR */
 delim[5] = ':';		/* : needed to parse /proc/net/dev or passwd */
 delim[6] = (char) NULL;        /* terminator */

 
 nextval = strtok(inbuffer,delim);
 if(nextval == (char *)NULL) return 0;
 strncpy(outfields[i++],nextval,maxfieldlength);
 if((verbose == VERBOSE) || (verbose == V_INIT)){
   printf("V_INIT: Parsed field[%d] = %s.\n",i-1,outfields[i-1]);
 }

 while(i < maxfields-1){
   nextval = strtok((char *) NULL, delim);
   if(nextval == (char *)NULL) break;
   strncpy(outfields[i++], nextval,maxfieldlength);
   if((verbose == VERBOSE) || (verbose == V_INIT)){
     printf("V_INIT: Parsed field[%d] = %s.\n",i-1,outfields[i-1]);
   }
 }

 /* Null the last field */
 bzero(outfields[i],maxfieldlength);
 if((verbose == VERBOSE) || (verbose == V_INIT){
   printf("V_INIT: Terminated field[%d] = %s.\n",i,outfields[i]);
 }

 return i;

}

