/*
 * $Id: multiply.c,v 1.4 2004/06/15 05:12:36 rgb Exp $
 * See copyright in copyright.h and the accompanying file COPYING
 */

#include "cpu_rate.h"

 /*
  *==================================================================
  * This is the "multiply test".  It basically measures the time
  * required to call a generic empty (multiply) function and how
  * accurately the timing harness is at determining a NET time for
  * executing its (empty) contents.
  *==================================================================
  */

void multiply_init(Test *mytest){

 mytest->alloc = multiply_alloc;
 mytest->free = multiply_free;
 mytest->test = multiply_test;
 mytest->results = multiply_results;
 snprintf(mytest->name,K,"multiply test");
 snprintf(mytest->about,K,"result = xtest*ytest");

 if(verbose == VERBOSE || verbose == V_INIT){
   printf("# Init for test %s\n",mytest->name);
 }

}

void multiply_alloc()
{
}

void multiply_free()
{
}

int multiply_test(int full_flag)
{

 if(full_flag != 0){
   /* Full */
   result = xtest*ytest;
   return(full_flag);
 } else {
   /* Empty */
   return(full_flag);
 }

}

void multiply_results(Test *mytest)
{

 /*
  * Any conversion or renormalization should happen here, but
  * the actual output line should be the same for all tests.
  */
 mytest->avg_time = fabs(mytest->avg_time_full - mytest->avg_time_empty);
 mytest->sigma = (mytest->sigma_time_full + mytest->sigma_time_empty);
 mytest->avg_megarate = 1000.0/mytest->avg_time;

 show_results(mytest);

}

