/*
* $Id: mem_write.c,v 1.4 2004/06/14 23:38:49 rgb Exp $
*
* See copyright in copyright.h and the accompanying file COPYING
*
*/

#include "cpu_rate.h"

 /*
  *==================================================================
  * This is the sequential or random write "memtest" benchmark, 
  * wrapped up in this timing engine and fitted with a variable stride.
  *==================================================================
  */

void mem_write_init(Test *mytest){

 int i;

 mytest->alloc = mem_write_alloc;
 mytest->free = mem_write_free;
 mytest->test = mem_write_test;
 mytest->results = mem_write_results;
 snprintf(mytest->name,K,"memory write");
 snprintf(mytest->about,K,"Writes (%d byte integer vector)",sizeof(int));

}

void mem_write_alloc()
{

 int i;

 /*
  * Allocate vector(s) to be tested with and initialize it and all
  * associated test-specific variables.
  */
 ai = (unsigned int *) malloc((size_t) (size*sizeof(unsigned int)));
 /* Initialize the vector */
 for(i=0;i<size;i+=stride){
   ai[i] = i;
 }

 if(verbose == VERBOSE || verbose == V_INIT){
   printf("#==================================================================\n");
   for(i=0;i<size;i++) printf("# Unshuffled: ai[%d] = %u\n",i,ai[i]);
   printf("#========================================================================\n");
 }

}

void mem_write_free()
{

 int i;

 /*
  * Free all the memory we just allocated, to be neat and clean and
  * all that.
  */
 free(ai);

}

int mem_write_test(int full_flag)
{
 int i;
 if(full_flag){
   /* Full */
   for(i=0; i<size; i+=stride){
     aindex = ai[i];
     aitmp = ai[aindex];
     ai[aindex] = aitmp;
   }
   return(full_flag);
 } else {
   /* Empty */
   for(i=0; i<size; i+=stride){
     aindex = ai[i];
     aitmp = ai[aindex];
   }
   return(full_flag);
 }
}

void mem_write_results(Test *mytest)
{

 double nanotime_norm;

 /*
  * This is basically the number of core loop executions
  */
 nanotime_norm = size/(double)stride;

 mytest->avg_time = fabs(mytest->avg_time_full - mytest->avg_time_empty)/nanotime_norm;
 mytest->sigma = (mytest->sigma_time_full + mytest->sigma_time_empty)/nanotime_norm;
 mytest->avg_megarate = 1000.0/mytest->avg_time;

 show_results(mytest);

}

