/*
* $Id: mem_rseq_simple_test.c,v 1.1 2003/02/26 22:20:51 rgb Exp $
*
* See copyright in copyright.h and the accompanying file COPYING
*
*/

#include "cpu_rate.h"

 /*
  *==================================================================
  * testid = 7
  * 
  * This is the pretty much my old sequential "memtest" benchmark, 
  * wrapped up in this timing engine and fitted with a variable stride.
  * This form uses ai[i] = i, which effectly means that it streams
  * through memory vector style, getting two values from the
  * vector, putting one in j, then putting j back where it came
  * from.
  *==================================================================
  */

int mem_rseq_simple_func(int full_flag)
{
 int i;
 if(full_flag){
   /* Full */
   for(i=0; i<size; i+=stride){
     aindex = ai[i];
     aitmp = ai[aindex];
     ai[aindex] = aitmp;
   }
   return(full_flag);
 } else {
   /* Empty */
   for(i=0; i<size; i+=stride){
     aindex = ai[i];
   }
   return(full_flag);
 }
}

void mem_rseq_simple_results()
{

 int vector_length = size*sizeof(unsigned int);
 
 nanotime_norm = (double) 2.0*size/(double) stride;
 avg_nanotime = fabs(avg_time_full - avg_time_empty)/nanotime_norm;
 avg_nanotime_sigma = (sigma_time_full + sigma_time_empty)/nanotime_norm;
 avg_megarate = 1000.0/avg_nanotime;

 if(!quiet){
   printf("# Simple Reverse Sequential Integer Memory (read/write) Access:\n");
   printf("# size = %d  stride = %d  vector length = %d:\n",size,stride,vector_length);
   printf("#   aitmp = ai[aindex]\n");
   printf("#   ai[aindex] = aitmp\n");
   printf("#   where aindex = ai[i] = i initially.\n");
   printf("# NANOTIMER granularity (nsec/cycle) = %6.3f\n",nsec_granularity);
   printf("# avg_time_full = %f avg_time_empty = %f \n",avg_time_full/nanotime_norm,avg_time_empty/nanotime_norm);
   printf("# Average Time: %6.2f +/- %9.6f nanoseconds\n",avg_nanotime,avg_nanotime_sigma);
   printf("# BogomegaRate: %6.2f mega_mem_rseq_simple int read/writes per second\n",avg_megarate);
 } else {
   printf("%12d (bytes)    %6.2f (bogom_mem_rseq_sipmles) with stride %d\n",size*sizeof(double),avg_megarate,stride);
 }

}
