/*
 *========================================================================
 * $Id: init_hostinfo.c,v 1.2 2004/06/14 13:44:16 rgb Exp $
 *
 * See copyright in copyright.h and the accompanying file COPYING
 *========================================================================
 */

/*
 *========================================================================
 * This routine initializes all host info for a report by e.g. parsing
 * /proc (one of my specialities:-) and various systems calls.
 *========================================================================
 */

#include "cpu_rate.h"

void init_hostinfo()
{

 int numfields;
 char statbuf[K];
 char delim[8],*nextval;
 FILE *procfd;

 /*
  * Get the hostname.
  */
 gethostname(host.hostname,128);

 /*
  * Get various bits of CPU info.
  */
 delim[0] = (char) 9;           /* tab */
 delim[1] = ',';                /* comma */
 delim[2] = (char) 10;		/* LF */
 delim[3] = (char) 13;		/* CR */
 delim[4] = ':';		/* : needed to parse /proc/net/dev or passwd */
 delim[5] = (char) NULL;        /* terminator */


 /*
  * Parse out cpu info
  */
 procfd = fopen("/proc/cpuinfo","r");
 while(-1){

   /* Normal EOF causes break from while loop */
   if((fgets(statbuf,K,procfd) == NULL)) break;

   if(strncmp(statbuf,"vendor_id",9) == 0) {
     nextval = strtok(statbuf,delim);       /* first field skip */
     nextval = strtok((char *)NULL,delim);  /* second field is it */
     snprintf(host.vendor_id,127,"%s",nextval);
   } else if(strncmp(statbuf,"model name",10) == 0) {
     nextval = strtok(statbuf,delim);       /* first field skip */
     nextval = strtok((char *)NULL,delim);  /* second field is it */
     snprintf(host.name,127,"%s",nextval);
   } else if(strncmp(statbuf,"cache size",10) == 0) {
     nextval = strtok(statbuf,delim);       /* first field skip */
     nextval = strtok((char *)NULL,delim);  /* second field is it */
     snprintf(host.l2cache,127,"%s",nextval);
   } else if(strncmp(statbuf,"cpu MHz",7) == 0) {
     nextval = strtok(statbuf,delim);       /* first field skip */
     nextval = strtok((char *)NULL,delim);  /* second field is it */
     snprintf(host.speed,127,"%s",nextval);
   } else if(strncmp(statbuf,"bogomips",8) == 0) {
     nextval = strtok(statbuf,delim);       /* first field skip */
     nextval = strtok((char *)NULL,delim);  /* second field is it */
     snprintf(host.bogomips,127,"%s",nextval);
   }
 }
 fclose(procfd);

 /*
  * Parse out memory info
  */
 procfd = fopen("/proc/meminfo","r");
 delim[5] = ' ';                /* Grrr space grrr */
 delim[6] = (char) NULL;        /* terminator */
 while(-1){

   /* Normal EOF causes break from while loop */
   if((fgets(statbuf,K,procfd) == NULL)) break;

   if(strncmp(statbuf,"Mem:",4) == 0) {
     nextval = strtok(statbuf,delim);       /* first field skip */
     nextval = strtok((char *)NULL,delim);  /* second field is it */
     snprintf(host.memory,127,"%s",nextval);
   }
 }
 fclose(procfd);

}
