/*
* $Id: empty_test.c,v 1.5 2004/06/15 05:12:36 rgb Exp $
*
* See copyright in copyright.h and the accompanying file COPYING
*
*/

#include "cpu_rate.h"

 /*
  *==================================================================
  * testid = 0
  * 
  * This is the "empty test" or "null test".  It basically measures
  * both the time required to call a generic empty function and how
  * accurately the timing harness is at determining a NET time for
  * executing its (empty) contents.
  *==================================================================
  */

void empty(){}

int empty_func(int full_flag)
{
 if(full_flag){
   /* Full */
   empty();
   return(full_flag);
 } else {
   /* Empty */
   return(full_flag);
 }
}

void empty_results()
{

 avg_nanotime = fabs(avg_time_full - avg_time_empty);
 avg_nanotime_sigma = sigma_time_full + sigma_time_empty;
 avg_megarate = 1000.0/avg_nanotime;
 if(!quiet){
   printf("# Empty loop/Null test validation:\n");
   printf("#   NANOTIMER granularity (nsec/cycle) = %6.3f\n",nanotimer.nsec_granularity);
   printf("#   dummy = idiot (basically null command) \n");
   printf("# Average Time: %6.2f +/- %9.6f nanoseconds\n",avg_nanotime,avg_nanotime_sigma);
   printf("# BogomegaRate: %6.2f megaemptiess per second (should be large)\n",avg_megarate);
 } else {
   printf("%12d (loop passes)    %6.2f (bogomempties)\n",size,avg_megarate);
 }

}
